/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.TrackNamePanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackPanel
extends IGVPanel {
    public static int X_SPACING_BETWEEN_COMPONENTS = 10;
    private String name = null;
    private TrackNamePanel namePanel;
    private AttributePanel attributePanel;
    private DataPanel dataPanel;
    private String groupAttribute;
    int trackCountEstimate = 0;
    List<TrackGroup> trackGroups;

    public TrackPanel(String name) {
        this.name = name;
        TrackGroup nullGroup = new TrackGroup();
        nullGroup.setDrawBorder(false);
        this.trackGroups = new LinkedList<TrackGroup>();
        this.trackGroups.add(nullGroup);
        this.init();
    }

    private void init() {
        this.setLayout(new AbsoluteLayout());
        this.namePanel = new TrackNamePanel(this);
        this.attributePanel = new AttributePanel(this);
        this.dataPanel = new DataPanel(this);
        this.add((Component)this.namePanel, new AbsoluteConstraints(0, 0, 150, 230));
        this.add((Component)this.attributePanel, new AbsoluteConstraints(160, 0, 120, 230));
        this.add((Component)this.dataPanel, new AbsoluteConstraints(290, 0, 710, 230));
    }

    public TrackNamePanel getNamePanel() {
        return this.namePanel;
    }

    public AttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public DataPanel getDataPanel() {
        return this.dataPanel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<TrackGroup> getGroups() {
        return this.trackGroups;
    }

    public boolean hasTracks() {
        for (TrackGroup tg : this.trackGroups) {
            if (tg.getTracks().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackGroup tg : this.trackGroups) {
            for (Track t : tg.getTracks()) {
                if (!t.isVisible()) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Track> getTracks() {
        ArrayList<Track> tracks = new ArrayList<Track>(this.trackCountEstimate);
        for (TrackGroup tg : this.trackGroups) {
            tracks.addAll(tg.getTracks());
        }
        return tracks;
    }

    public void clearTracks() {
        this.trackGroups.clear();
        this.trackCountEstimate = 0;
    }

    public void addTrack(Track track) {
        String groupName = this.groupAttribute == null ? null : track.getAttributeValue(this.groupAttribute);
        boolean foundGroup = false;
        for (TrackGroup tg : this.trackGroups) {
            if (this.groupAttribute != null && groupName != null && !tg.getName().equals(groupName)) continue;
            tg.add(track);
            foundGroup = true;
            break;
        }
        if (!foundGroup) {
            TrackGroup newGroup = new TrackGroup(groupName);
            newGroup.add(track);
            if (this.groupAttribute == null) {
                newGroup.setDrawBorder(false);
            }
            this.trackGroups.add(newGroup);
        }
        ++this.trackCountEstimate;
    }

    public void addTracks(Collection<Track> tracks) {
        for (Track t : tracks) {
            this.addTrack(t);
        }
    }

    public void moveGroup(TrackGroup group, int index) {
        if (index > this.trackGroups.indexOf(group)) {
            --index;
        }
        this.trackGroups.remove(group);
        if (index >= this.trackGroups.size()) {
            this.trackGroups.add(group);
        } else {
            this.trackGroups.add(index, group);
        }
    }

    public void reset() {
        this.groupAttribute = null;
        this.trackGroups.clear();
    }

    public void groupTracksByAttribute(String attribute) {
        this.groupAttribute = attribute;
        List<Track> tracks = this.getTracks();
        this.trackGroups.clear();
        if (attribute == null || attribute.length() == 0) {
            TrackGroup nullGroup = new TrackGroup();
            nullGroup.addAll(tracks);
            nullGroup.setDrawBorder(false);
            this.trackGroups.add(nullGroup);
        } else {
            HashMap<String, TrackGroup> groupMap = new HashMap<String, TrackGroup>();
            for (Track track : tracks) {
                TrackGroup group;
                String attributeValue = track.getAttributeValue(attribute);
                if (attributeValue == null) {
                    attributeValue = "";
                }
                if ((group = (TrackGroup)groupMap.get(attributeValue)) == null) {
                    group = new TrackGroup(attributeValue);
                    groupMap.put(attributeValue, group);
                    this.trackGroups.add(group);
                }
                group.add(track);
            }
        }
    }

    public void sortTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByAttributes(attributeNames, ascending);
        }
    }

    public void sortTracksByPosition(List<String> trackIds) {
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByList(trackIds);
        }
    }

    public void sortByRegionsScore(RegionOfInterest region, RegionScoreType type) {
        boolean useLinkedSorting = PreferenceManager.getInstance().isLinkedSortingEnabled();
        String linkingAtt = IGVMainFrame.getInstance().getSession().getOverlayAttribute();
        this.sortGroupsByRegionScore(this.trackGroups, region, type);
        for (TrackGroup group : this.trackGroups) {
            if (linkingAtt != null && !useLinkedSorting) {
                group.sortByRegionScore(region, type);
                continue;
            }
            group.sortGroup(region, linkingAtt, type);
        }
    }

    private void sortGroupsByRegionScore(List<TrackGroup> groups, RegionOfInterest region, final RegionScoreType type) {
        if (groups != null && region != null && !groups.isEmpty()) {
            final int zoom = Math.max(0, ViewContext.getInstance().getZoom());
            final String chr = region.getChr();
            final int start = region.getStart();
            final int end = region.getEnd();
            Comparator<TrackGroup> c2 = new Comparator<TrackGroup>(){

                @Override
                public int compare(TrackGroup group1, TrackGroup group2) {
                    float s1 = group1.getRegionScore(chr, start, end, zoom, type);
                    float s2 = group2.getRegionScore(chr, start, end, zoom, type);
                    if (s2 > s1) {
                        return 1;
                    }
                    if (s1 < s2) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(groups, c2);
        }
    }

    public boolean setGeneTrack(Track geneTrack, Track newGeneTrack) {
        boolean foundGeneTrack = false;
        for (TrackGroup g2 : this.trackGroups) {
            if (!g2.contains(geneTrack)) continue;
            int geneTrackIndex = g2.indexOf(geneTrack);
            g2.remove(geneTrack);
            geneTrackIndex = Math.min(g2.size(), geneTrackIndex);
            g2.add(geneTrackIndex, newGeneTrack);
            foundGeneTrack = true;
        }
        return foundGeneTrack;
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        for (TrackGroup tg : this.trackGroups) {
            tg.removeTracks(tracksToRemove);
        }
    }

    public void moveSelectedTracksTo(Collection<Track> selectedTracks, Track targetTrack, boolean before) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        for (TrackGroup tg : this.trackGroups) {
            if (!tg.moveSelectedTracksTo(selectedTracks, targetTrack, before)) continue;
            return;
        }
    }

    public int getPreferredPanelHeight() {
        int height = 0;
        List<TrackGroup> groups = this.getGroups();
        if (groups.size() > 1) {
            height += 10;
        }
        for (TrackGroup group : groups) {
            if (group == null || !group.isVisible()) continue;
            if (groups.size() > 1) {
                height += 10;
            }
            height += group.getPreferredHeight();
        }
        return Math.max(20, height);
    }
}

