/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVTool;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DragEventManager;

public class PanAndZoomTool
extends IGVTool {
    private int previousYDirection = 0;
    private int lastMousePressedY;
    private int cumulativeDeltaX;
    private int cumulativeDeltaY;
    private Point lastMousePoint;
    private JViewport viewport;
    private Container panel;
    private JScrollBar verticalScrollBar;
    private boolean isDragging = false;
    private Cursor dragCursor = IGVMainFrame.fistCursor;

    public PanAndZoomTool(Component owner) {
        super(owner, IGVMainFrame.handCursor);
        this.setName("Zoom");
    }

    public Cursor getCursor() {
        return this.isDragging ? this.dragCursor : super.getCursor();
    }

    public void mousePressed(MouseEvent e2) {
        this.panel = (Container)e2.getSource();
        this.panel.setCursor(this.dragCursor);
        this.lastMousePoint = e2.getPoint();
        this.lastMousePressedY = (int)e2.getPoint().getY();
        this.cumulativeDeltaX = 0;
        this.cumulativeDeltaY = 0;
        if (this.panel != null && this.panel instanceof DataPanel) {
            Container parentOfParent;
            this.verticalScrollBar = ((DataPanel)this.panel).getVerticalScrollbar();
            Container parentContainer = this.panel.getParent();
            if (parentContainer != null && (parentOfParent = parentContainer.getParent()) != null && parentOfParent instanceof JViewport) {
                this.viewport = (JViewport)parentOfParent;
            }
        }
    }

    public void mouseReleased(MouseEvent e2) {
        this.viewport = null;
        if (this.isDragging) {
            this.getViewContext().snapToGrid();
            this.isDragging = false;
            DragEventManager.getInstance().dragStopped();
            this.getViewContext().recordHistory();
        }
        ((JComponent)e2.getSource()).setCursor(this.getCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mouseDragged(MouseEvent e2) {
        block16: {
            try {
                if (this.lastMousePoint == null) {
                    this.lastMousePoint = e2.getPoint();
                    return;
                }
                if (!this.isDragging && e2.getPoint().distance(this.lastMousePoint) < 2.0) {
                    return;
                }
                this.isDragging = true;
                double deltaX = this.lastMousePoint.getX() - (double)e2.getX();
                double deltaY = this.lastMousePoint.getY() - (double)e2.getY();
                this.cumulativeDeltaX = (int)((double)this.cumulativeDeltaX + Math.abs(deltaX));
                this.cumulativeDeltaY = (int)((double)this.cumulativeDeltaY + Math.abs(deltaY));
                if (this.cumulativeDeltaX > this.cumulativeDeltaY) {
                    this.getViewContext().shiftOriginPixels(deltaX);
                    return;
                }
                int totalYChange = this.lastMousePressedY - e2.getY();
                if (this.viewport == null || totalYChange == 0) break block16;
                int currentYDirection = 0;
                try {
                    currentYDirection = totalYChange / Math.abs(totalYChange);
                    if (this.previousYDirection != 0) {
                        boolean changedYDirection;
                        boolean bl = changedYDirection = currentYDirection != this.previousYDirection;
                        if (changedYDirection) {
                            return;
                        }
                    }
                }
                finally {
                    this.previousYDirection = currentYDirection;
                }
                if (this.verticalScrollBar != null) {
                    int adjustedScrollbarValue = this.verticalScrollBar.getValue();
                    this.verticalScrollBar.setValue(adjustedScrollbarValue += totalYChange);
                }
            }
            finally {
                this.lastMousePoint = e2.getPoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent e2) {
        Track track;
        ViewContext viewContext = this.getViewContext();
        Object source = e2.getSource();
        if (source instanceof DataPanel && (track = ((DataPanel)source).getTrack(e2.getX(), e2.getY())) != null && track.handleClick(e2)) {
            return;
        }
        if (e2.isShiftDown() || e2.isAltDown() || e2.getClickCount() > 1) {
            int currentZoom = viewContext.getZoom();
            int newZoom = e2.isAltDown() ? Math.max(currentZoom - 1, 0) : (e2.isShiftDown() ? currentZoom + 3 : currentZoom + 1);
            double locationClicked = viewContext.getChromosomePosition(e2.getX());
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                viewContext.zoomTo(newZoom, locationClicked);
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
    }
}

