/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.util.Packable;

public class HeaderPanel
extends JPanel {
    public HeaderPanel() {
        this.setDoubleBuffered(true);
    }

    public void setBounds(int x, int y, int width, int height) {
        int adjustedX = this.getAdjustedX();
        int adjustedWidth = this.getAdjustedWidth();
        super.setBounds(adjustedX, y, adjustedWidth, height);
    }

    public void setBounds(Rectangle r) {
        int adjustedX = this.getAdjustedX();
        int adjustedWidth = this.getAdjustedWidth();
        super.setBounds(new Rectangle(adjustedX, r.y, adjustedWidth, r.height));
    }

    public void setSize(int width, int height) {
        int adjustedWidth = this.getAdjustedWidth();
        super.setSize(adjustedWidth, height);
    }

    public void setSize(Dimension d2) {
        int adjustedWidth = this.getAdjustedWidth();
        super.setSize(new Dimension(adjustedWidth, d2.height));
    }

    private int getAdjustedX() {
        Component[] children;
        int adjustedX = 0;
        Integer attributePanelEnd = null;
        int width = 0;
        for (Component child : children = this.getParent().getComponents()) {
            int x;
            if (!(child instanceof Packable)) continue;
            if (attributePanelEnd != null) break;
            adjustedX = x = child.getX();
            width = child.getWidth();
            attributePanelEnd = new Integer(x + width);
            break;
        }
        if (attributePanelEnd != null) {
            adjustedX = attributePanelEnd;
            if (width > 0) {
                adjustedX += IGVPanel.X_SPACING_BETWEEN_COMPONENTS;
            }
        }
        return adjustedX;
    }

    private int getAdjustedWidth() {
        int minimumWidth;
        int width = this.getWidth();
        Container parent = this.getParent();
        if (parent != null) {
            int parentVisibleWidth = ((JPanel)parent).getVisibleRect().width;
            int viewportWidth = this.getViewportWidth();
            if (parentVisibleWidth < viewportWidth) {
                viewportWidth = parentVisibleWidth;
            }
            int delta = viewportWidth - (this.getX() + width);
            width = this.getWidth() + delta;
        }
        if (width < (minimumWidth = this.getMinimumSize().width)) {
            width = minimumWidth;
        }
        return width;
    }

    private int getViewportWidth() {
        int width = 0;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            int parentVisibleWidth = ((JPanel)parent).getVisibleRect().width;
            width = (int)((JViewport)parent).getViewSize().getWidth();
            if (parentVisibleWidth < width) {
                width = parentVisibleWidth;
            }
        } else {
            width = parent.getWidth();
        }
        return width;
    }

    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        g2.setColor(Color.BLACK);
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.drawLine(0, 0, width - 1, 0);
        g2.drawLine(0, 0, 0, height);
        g2.drawLine(width - 1, 0, width - 1, height);
    }
}

