/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.renderer.CytobandRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.WaitCursorManager;

public class CytobandPanel
extends JPanel {
    private static int fontHeight = 10;
    private static int bandHeight = 10;
    private static String fontFamilyName = "Lucida Sans";
    private boolean isDragging = false;
    private double viewOrigin;
    double cytobandScale;
    int toolOrigin = -1;

    public CytobandPanel() {
        FontManager.getScalableFont(fontHeight);
        this.setFont(new Font(fontFamilyName, 1, fontHeight));
        this.initialize();
    }

    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.getViewContext().getChrName().equals("All")) {
            Graphics g22 = g2.create();
            g22.setFont(FontManager.getScalableFont(2, 12));
            String text = "Whole genome view.  To jump to a chromosome click on its label.";
            g22.drawString(text, 20, this.getHeight() - 5);
            return;
        }
        int dataPanelWidth = this.getWidth();
        Rectangle cytoRect = new Rectangle(0, 10, dataPanelWidth, bandHeight);
        Chromosome chromosome = this.getViewContext().getChromosome();
        if (chromosome == null) {
            return;
        }
        List<Cytoband> cytobands = chromosome.getCytobands();
        if (cytobands == null) {
            return;
        }
        new CytobandRenderer().draw(cytobands, g2, cytoRect);
        int chromosomeLength = this.getViewContext().getChromosomeLength();
        this.cytobandScale = (double)chromosomeLength / (double)dataPanelWidth;
        if (this.getViewContext().getZoom() > 0) {
            double scale = this.getViewContext().getScale();
            double origin = this.isDragging ? this.viewOrigin : this.getViewContext().getOrigin();
            int start = (int)(origin / this.cytobandScale);
            double scaledDataPanelWidth = (double)dataPanelWidth * scale;
            int span = (int)(scaledDataPanelWidth / this.cytobandScale);
            int height = (int)cytoRect.getHeight();
            g2.setColor(Color.RED);
            int y = (int)cytoRect.getY() + 5;
            g2.drawRect(start, y, span, height);
            g2.drawRect(start - 1, y - 1, span + 2, height + 2);
            g2.drawRect(start - 2, y - 2, span + 4, height + 4);
            if (span < 2) {
                g2.drawRect(start - 2, y - 2, span + 4, height + 4);
            }
        }
    }

    private void initialize() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("<html>Click anywhere on the cytoband <p>to center view at that location.");
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e2) {
                int mouseX = e2.getX();
                int clickCount = e2.getClickCount();
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    double newLocation = CytobandPanel.this.cytobandScale * (double)mouseX;
                    if (clickCount > 1) {
                        int newZoom = CytobandPanel.this.getViewContext().getZoom() + 1;
                        CytobandPanel.this.getViewContext().zoomTo(newZoom, newLocation);
                    } else {
                        CytobandPanel.this.getViewContext().centerOnLocation(newLocation);
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    WaitCursorManager.removeWaitCursor(token);
                    throw throwable;
                }
                WaitCursorManager.removeWaitCursor(token);
            }

            public void mousePressed(MouseEvent e2) {
                this.lastMousePressX = e2.getX();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent e2) {
                if (CytobandPanel.this.isDragging) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        CytobandPanel.this.getViewContext().setOrigin(CytobandPanel.this.viewOrigin);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        WaitCursorManager.removeWaitCursor(token);
                        throw throwable;
                    }
                    WaitCursorManager.removeWaitCursor(token);
                    {
                    }
                }
                CytobandPanel.this.isDragging = false;
            }

            public void mouseDragged(MouseEvent e2) {
                if (!CytobandPanel.this.isDragging) {
                    CytobandPanel.this.isDragging = true;
                    CytobandPanel.this.viewOrigin = CytobandPanel.this.getViewContext().getOrigin();
                }
                int w = CytobandPanel.this.getWidth();
                double scale = CytobandPanel.this.getViewContext().getScale();
                int x = (int)Math.max(0.0, Math.min((double)e2.getX(), (double)w * (CytobandPanel.this.cytobandScale - scale)));
                int delta = x - this.lastMousePressX;
                if (delta != 0 && CytobandPanel.this.cytobandScale > 0.0) {
                    CytobandPanel.this.viewOrigin = Math.max(0.0, Math.min(CytobandPanel.this.viewOrigin + (double)delta * CytobandPanel.this.cytobandScale, (double)w * (CytobandPanel.this.cytobandScale - scale)));
                    CytobandPanel.this.repaint();
                }
                this.lastMousePressX = x;
            }

            public void mouseEntered(MouseEvent e2) {
            }

            public void mouseExited(MouseEvent e2) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private ViewContext getViewContext() {
        return ViewContext.getInstance();
    }
}

