/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.Packable;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributePanel
extends TrackPanelComponent
implements Packable {
    private static Logger log = Logger.getLogger(AttributePanel.class);
    private static Map<String, Color> colorMap = new Hashtable<String, Color>();
    Map<String, Integer> colorCounter = new HashMap<String, Integer>();

    public AttributePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.init();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.removeMousableRegions();
        List<String> keys = AttributeManager.getInstance().getAttributeKeys();
        keys.removeAll(AttributeManager.getInstance().getHiddenAttributes());
        if (keys == null) {
            return;
        }
        if (keys.size() > 0) {
            Rectangle visibleRect = this.getVisibleRect();
            TrackPanel trackPanel = (TrackPanel)this.getParent();
            List<TrackGroup> groups = trackPanel.getGroups();
            if (!groups.isEmpty()) {
                int attributeColumnWidth = this.getAttributeColumnWidth();
                Graphics2D graphics2D = (Graphics2D)g2.create();
                graphics2D.setColor(Color.BLACK);
                Graphics2D greyGraphics = (Graphics2D)g2.create();
                greyGraphics.setColor(UIConstants.VERY_LIGHT_GRAY);
                int regionX = 3;
                int regionY = 0;
                for (TrackGroup group : groups) {
                    if (regionY > visibleRect.y + visibleRect.height) break;
                    if (!group.isVisible()) continue;
                    if (groups.size() > 1) {
                        greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                        regionY += 10;
                    }
                    if (group.isDrawBorder()) {
                        g2.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                    }
                    for (Track track : group.getTracks()) {
                        int trackHeight = track.getHeight();
                        if (regionY > visibleRect.y + visibleRect.height) break;
                        if (!track.isVisible()) continue;
                        if (regionY + trackHeight >= visibleRect.y) {
                            regionY = this.draw(keys, track, regionX, regionY, attributeColumnWidth, track.getHeight(), graphics2D);
                            continue;
                        }
                        regionY += trackHeight;
                    }
                    if (!group.isDrawBorder()) continue;
                    g2.drawLine(0, regionY, this.getWidth(), regionY);
                }
            }
        }
    }

    private Color getColor(String attKey, String attValue) {
        if (attValue == null || attValue.length() == 0) {
            return Color.white;
        }
        String key = (attKey + "_" + attValue).toLowerCase();
        Color c2 = colorMap.get(key);
        if (c2 == null) {
            Integer cnt = this.colorCounter.get(attKey);
            if (cnt == null) {
                cnt = 0;
            }
            Integer n2 = cnt;
            Integer n3 = cnt = Integer.valueOf(cnt + 1);
            this.colorCounter.put(attKey, cnt);
            float hue = (float)(0.4 + 0.2 * Math.random());
            c2 = AttributePanel.randomColor(cnt);
            colorMap.put(key, c2);
        }
        return c2;
    }

    public static Color randomColor(int idx) {
        float hue = (float)Math.random();
        float sat = (float)(0.8 * Math.random());
        float bri = (float)(0.6 + 0.4 * Math.random());
        return Color.getHSBColor(hue, sat, bri);
    }

    private int draw(List<String> keys, Track track, int trackX, int trackY, int trackWidth, int trackHeight, Graphics2D graphics) {
        for (String key : keys) {
            String attributeValue = track.getAttributeValue(key);
            if (attributeValue != null) {
                Rectangle trackRectangle = new Rectangle(trackX, trackY, trackWidth, trackHeight);
                graphics.setColor(this.getColor(key, attributeValue));
                graphics.fill(trackRectangle);
                this.addMousableRegion(new MouseableRegion(trackRectangle, key, attributeValue));
            }
            trackX += trackWidth + 2;
        }
        return trackY += trackHeight;
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (!PreferenceManager.getInstance().getShowAttributeView()) {
            this.setSize(0, this.getHeight());
        }
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(0, 0));
        this.setVerifyInputWhenFocusTarget(false);
        GroupLayout dataTrackAttributePanelLayout = new GroupLayout(this);
        this.setLayout(dataTrackAttributePanelLayout);
        dataTrackAttributePanelLayout.setHorizontalGroup(dataTrackAttributePanelLayout.createParallelGroup(1).add(0, 118, Short.MAX_VALUE));
        dataTrackAttributePanelLayout.setVerticalGroup(dataTrackAttributePanelLayout.createParallelGroup(1).add(0, 528, Short.MAX_VALUE));
        AttributePanelMouseAdapter mouseAdapter = new AttributePanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> selectedTracks = this.getSelectedTracks();
        int selectedTrackCount = selectedTracks.size();
        if (selectedTrackCount == 1) {
            return selectedTracks.iterator().next().getName();
        }
        String keyValue = "";
        for (MouseableRegion region : this.getTrackRegions()) {
            if (!region.containsPoint(x, y)) continue;
            keyValue = region.getText();
        }
        return keyValue + " (" + selectedTrackCount + " tracks)";
    }

    public String getMouseDoc(int x, int y) {
        List<MouseableRegion> mouseRegions = this.getTrackRegions();
        for (MouseableRegion mr : mouseRegions) {
            if (!mr.containsPoint(x, y)) continue;
            return mr.getText();
        }
        return "";
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    public boolean isHorizontallyPackable() {
        return true;
    }

    public void packHorizontally() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    private int calculatePackWidth() {
        if (!PreferenceManager.getInstance().getShowAttributeView()) {
            return 0;
        }
        HashSet<String> attributeKeys = new HashSet<String>(AttributeManager.getInstance().getAttributeKeys());
        attributeKeys.removeAll(AttributeManager.getInstance().getHiddenAttributes());
        int attributeCount = attributeKeys.size();
        int packWidth = attributeCount * 12 + 2;
        return packWidth;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.calculatePackWidth(), height);
    }

    @Override
    public void packComponent() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    class AttributePanelMouseAdapter
    extends MouseInputAdapter {
        int lastMousePressX = 0;

        AttributePanelMouseAdapter() {
        }

        public void mousePressed(MouseEvent e2) {
            if (log.isDebugEnabled()) {
                log.debug("Enter mousePressed");
            }
            AttributePanel.this.clearTrackSelections();
            AttributePanel.this.selectTracks(e2);
            if (e2.isPopupTrigger()) {
                AttributePanel.this.openPopupMenu(e2);
            }
            IGVMainFrame.getInstance().repaintNamePanels();
        }

        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                AttributePanel.this.openPopupMenu(e2);
                AttributePanel.this.clearTrackSelections();
            }
        }

        public void mouseMoved(MouseEvent e2) {
            AttributePanel.this.setToolTipText(AttributePanel.this.getMouseDoc(e2.getX(), e2.getY()));
        }
    }
}

