/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.Command;
import org.broad.igv.ui.util.MessageUtils;

public class SearchCommand
implements Command {
    private static Logger log = Logger.getLogger(SearchCommand.class);
    String searchString;
    ViewContext viewContext;
    boolean recordHistory = true;
    Genome genome;

    public SearchCommand(ViewContext viewContext, String searchString) {
        this.viewContext = viewContext;
        this.searchString = searchString.trim();
        this.genome = viewContext.getGenome();
    }

    public SearchCommand(ViewContext viewContext, String searchString, boolean recordHistory) {
        this(viewContext, searchString);
        this.recordHistory = recordHistory;
    }

    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("Run search: " + this.searchString);
        }
        boolean success = false;
        String[] tokens = this.searchString.split("\\s+");
        if (tokens.length == 3) {
            String chr = tokens[0];
            String chrAlias = this.genome == null ? chr : this.genome.getChromosomeAlias(chr);
            int start = Integer.parseInt(tokens[1]) - 1;
            int end = Integer.parseInt(tokens[2]);
            this.viewContext.jumpTo(chrAlias, start, end);
            success = true;
        } else {
            Feature feature = FeatureDB.getFeature(this.searchString.toUpperCase().trim());
            if (feature != null) {
                int start = Math.max(0, feature.getStart());
                int end = feature.getEnd();
                if (PreferenceManager.getInstance().getBooleanPreference("SEARCH_ZOOM", true)) {
                    this.viewContext.jumpTo(feature.getChr(), start, end);
                } else {
                    int center = (start + end) / 2;
                    this.viewContext.centerOnLocation(feature.getChr(), center);
                }
                if (log.isDebugEnabled()) {
                    log.debug("End search: " + this.searchString);
                }
                success = true;
            } else if (!this.searchString.contains("\"")) {
                String chr = null;
                int[] startEnd = null;
                int colon = this.searchString.indexOf(":");
                if (colon > 0) {
                    chr = this.searchString.substring(0, colon);
                    String chrAlias = this.genome == null ? chr : this.genome.getChromosomeAlias(chr);
                    String posString = this.searchString.substring(colon).replace(":", "");
                    startEnd = this.getStartEnd(posString);
                    if (startEnd != null) {
                        this.viewContext.jumpTo(chrAlias, startEnd[0], startEnd[1]);
                        if (log.isDebugEnabled()) {
                            log.debug("End search: " + this.searchString);
                        }
                        success = true;
                    }
                } else if (this.searchString.contains("-")) {
                    startEnd = this.getStartEnd(this.searchString);
                    if (startEnd != null) {
                        this.viewContext.jumpTo(null, startEnd[0], startEnd[1]);
                        if (log.isDebugEnabled()) {
                            log.debug("End search: " + this.searchString);
                        }
                        success = true;
                    }
                } else {
                    String chrAlias = this.genome == null ? this.searchString : this.genome.getChromosomeAlias(this.searchString);
                    Chromosome chromosome = this.viewContext.getGenome().getChromosome(chrAlias);
                    if (chromosome != null || chrAlias.equals("All")) {
                        this.viewContext.setChromosomeName(chrAlias, true);
                        IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
                        IGVMainFrame.getInstance().repaintStatusAndZoomSlider();
                        if (log.isDebugEnabled()) {
                            log.debug("End search: " + this.searchString);
                        }
                        success = true;
                    }
                }
            }
        }
        if (success) {
            if (this.recordHistory) {
                this.viewContext.history.push(this.searchString);
            }
        } else if (!IGVMainFrame.getInstance().scrollToTrack(this.searchString.replaceAll("\"", ""))) {
            this.showError("Cannot find feature or locus: " + this.searchString);
        }
        if (log.isDebugEnabled()) {
            log.debug("End search: " + this.searchString);
        }
    }

    private int[] getStartEnd(String posString) {
        try {
            String endString;
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString)) - 1;
            int end = start + 1;
            if (posTokens.length > 1) {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end - start < 10) {
                int center = (start + end) / 2;
                start = center - 20;
                end = center + 20;
            } else {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void showError(String message) {
        MessageUtils.showMessage(message);
    }
}

