/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.ResourceTree;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFromServerAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFromServerAction.class);
    IGVMainFrame mainFrame;
    static HashSet<String> failedURLs = new HashSet();

    public LoadFromServerAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information from a server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        block29: {
            block28: {
                this.mainFrame.setStatusBarMessage("Loading ...");
                urlString = PreferenceManager.getInstance().getDataServerURL();
                genomeId = ViewContext.getInstance().getGenomeId();
                genomeURL = urlString.replaceAll("\\$\\$", genomeId);
                try {
                    try {
                        block26: {
                            block27: {
                                block25: {
                                    if (genomeURL.startsWith("http:") || genomeURL.startsWith("https:")) {
                                        genomeURL = genomeURL + "?genome=" + genomeId;
                                    }
                                    is = null;
                                    conn = null;
                                    urls = null;
                                    try {
                                        masterResourceFileURL = new URL(genomeURL);
                                        if (genomeURL.startsWith("ftp:")) {
                                            MessageUtils.showMessage("FTP protocol not supported for data registry URL");
                                            var11_16 = null;
                                            if (is == null) break block25;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (IOException e) {
                                        if (conn.getResponseCode() == 401) {
                                            msg = "Authorization failure accessing resource: " + genomeURL;
                                            MessageUtils.showMessage(msg);
                                            LoadFromServerAction.log.error("Error accessing URL: " + genomeURL, e);
                                        }
                                        var11_19 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (conn != null) {
                                            conn.disconnect();
                                        }
                                        break block26;
                                    }
                                    catch (Throwable var10_29) {
                                        var11_20 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (conn == null) throw var10_29;
                                        conn.disconnect();
                                        throw var10_29;
                                    }
                                    is.close();
                                }
                                if (conn != null) {
                                    conn.disconnect();
                                }
                                var13_21 = null;
                                this.mainFrame.showLoadedTrackCount();
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    block30: {
                                        if (!genomeURL.startsWith("http:") && !genomeURL.startsWith("https:")) break block30;
                                        conn = IGVHttpUtils.openConnection(masterResourceFileURL);
                                        conn.setReadTimeout(10000);
                                        conn.setConnectTimeout(10000);
                                        is = IGVHttpUtils.openHttpStream(masterResourceFileURL, conn);
                                        ** GOTO lbl69
                                    }
                                    file = new File(genomeURL.startsWith("file:") != false ? masterResourceFileURL.getFile() : genomeURL);
                                    if (file.exists()) ** GOTO lbl-1000
                                    MessageUtils.showMessage("ERROR: File does not exist: " + file.getAbsolutePath());
                                    var11_17 = null;
                                    if (is == null) break block27;
                                }
                                is.close();
                            }
                            if (conn == null) break block28;
                            conn.disconnect();
                            break block28;
lbl-1000:
                            // 1 sources

                            {
                                is = new FileInputStream(file);
lbl69:
                                // 2 sources

                                bufferedReader = new BufferedReader(new InputStreamReader(is));
                                urls = this.getResourceUrls(bufferedReader);
                            }
                            var11_18 = null;
                            if (is != null) {
                                is.close();
                            }
                            if (conn != null) {
                                conn.disconnect();
                            }
                        }
                        if (urls == null || urls.isEmpty()) {
                            JOptionPane.showMessageDialog(this.mainFrame, "No datasets are available for the current genome (" + genomeId + ").");
                            break block29;
                        }
                        locators = this.selectResources(urls);
                        if (locators != null) {
                            this.mainFrame.loadTracks(locators);
                        }
                        break block29;
                    }
                    catch (UnknownHostException e) {
                        msg = "The application could not contact the server: Unknown Host Failure\nHost: " + e.getMessage();
                        LoadFromServerAction.log.error(msg);
                        MessageUtils.showMessage(msg);
                        var13_24 = null;
                        this.mainFrame.showLoadedTrackCount();
                        return;
                    }
                    catch (ConnectException e) {
                        msg = "The application could not contact the server: Connection Failure!\n" + e.getMessage();
                        LoadFromServerAction.log.error(msg);
                        MessageUtils.showMessage(msg);
                        var13_25 = null;
                        this.mainFrame.showLoadedTrackCount();
                        return;
                    }
                    catch (Exception e) {
                        msg = "Could not load information from server!\n" + e.getMessage();
                        LoadFromServerAction.log.error(msg);
                        MessageUtils.showMessage(msg);
                        var13_26 = null;
                        this.mainFrame.showLoadedTrackCount();
                        return;
                    }
                }
                catch (Throwable var12_30) {
                    var13_27 = null;
                    this.mainFrame.showLoadedTrackCount();
                    throw var12_30;
                }
            }
            var13_22 = null;
            this.mainFrame.showLoadedTrackCount();
            return;
        }
        var13_23 = null;
        this.mainFrame.showLoadedTrackCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ResourceLocator> selectResources(LinkedHashSet<URL> xmlUrls) {
        ArrayList<ResourceLocator> arrayList;
        if (xmlUrls == null || xmlUrls.isEmpty()) {
            log.error("No datasets are available from this server for the current genome (");
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean xmlParsingError = false;
        try {
            try {
                buffer.append("<html>The following urls could not be processed due to load failures:<br>");
                Document masterDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element rootNode = masterDocument.createElement("Global");
                rootNode.setAttribute("name", "Available Datasets");
                rootNode.setAttribute("version", "1");
                masterDocument.appendChild(rootNode);
                for (URL url : xmlUrls) {
                    if (failedURLs.contains(url.toString())) continue;
                    try {
                        Document xmlDocument;
                        block31: {
                            HttpURLConnection connection;
                            block32: {
                                Object var14_22;
                                connection = null;
                                InputStream is = null;
                                xmlDocument = null;
                                try {
                                    try {
                                        connection = IGVHttpUtils.openConnection(url);
                                        connection.setConnectTimeout(10000);
                                        connection.setReadTimeout(10000);
                                        is = IGVHttpUtils.openHttpStream(url, connection);
                                        xmlDocument = Utilities.createDOMDocumentFromXmlStream(is);
                                    }
                                    catch (SocketTimeoutException e2) {
                                        xmlParsingError = true;
                                        buffer.append("Error. Connection time out reading: " + url.toString());
                                        var14_22 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (connection == null) continue;
                                        connection.disconnect();
                                        continue;
                                    }
                                    catch (SAXParseException e3) {
                                        log.error("Invalid XML resource: " + url, e3);
                                        xmlParsingError = true;
                                        buffer.append(url);
                                        buffer.append("<br><i>");
                                        if (url.toString().contains("iwww.broad")) {
                                            buffer.append("File could not be loaded from the Broad Intranet");
                                        } else {
                                            buffer.append(e3.getMessage());
                                        }
                                        buffer.append("");
                                        var14_22 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (connection == null) continue;
                                        connection.disconnect();
                                        continue;
                                    }
                                    catch (FileNotFoundException e4) {
                                        String message = "Could not find file represented by " + url.toString();
                                        log.error(message, e4);
                                        xmlParsingError = true;
                                        buffer.append(url);
                                        buffer.append("\t  [");
                                        buffer.append(e4.getMessage());
                                        buffer.append("]\n");
                                        var14_22 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (connection == null) continue;
                                        connection.disconnect();
                                        continue;
                                    }
                                    catch (IOException e5) {
                                        String msg = "";
                                        if (connection.getResponseCode() == 401) {
                                            failedURLs.add(url.toString());
                                            msg = "Authorization failure accessing resource: " + url;
                                        } else {
                                            msg = "Error accessing dataset list: " + e5.toString();
                                        }
                                        MessageUtils.showMessage(msg);
                                        log.error("Error accessing URL: " + url, e5);
                                        var14_22 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (connection != null) {
                                            connection.disconnect();
                                        }
                                        break block31;
                                    }
                                    var14_22 = null;
                                    if (is == null) break block32;
                                }
                                catch (Throwable throwable) {
                                    var14_22 = null;
                                    if (is != null) {
                                        is.close();
                                    }
                                    if (connection == null) throw throwable;
                                    connection.disconnect();
                                    throw throwable;
                                }
                                is.close();
                            }
                            if (connection != null) {
                                connection.disconnect();
                            }
                        }
                        if (xmlDocument == null) continue;
                        NodeList elements = xmlDocument.getElementsByTagName("Global");
                        Element global = (Element)elements.item(0);
                        NodeList nodes = global.getChildNodes();
                        Element categoryNode = masterDocument.createElement("Category");
                        categoryNode.setAttribute("name", global.getAttribute("name"));
                        categoryNode.setAttribute("hyperlink", global.getAttribute("hyperlink"));
                        rootNode.appendChild(categoryNode);
                        int size = nodes.getLength();
                        for (int i2 = 0; i2 < size; ++i2) {
                            categoryNode.appendChild(masterDocument.importNode(nodes.item(i2), true));
                        }
                    }
                    catch (Exception e6) {
                        String message = "Cannot create an XML Document from " + url.toString();
                        log.error(message, e6);
                    }
                }
                if (xmlParsingError) {
                    JOptionPane.showMessageDialog(this.mainFrame, buffer.toString());
                }
                HashSet<ResourceLocator> selectedLocators = ResourceTree.getInstance().showResourceTreeDialog(this.mainFrame, masterDocument, "Available Datasets");
                ArrayList<ResourceLocator> newLoadList = new ArrayList<ResourceLocator>();
                Set<ResourceLocator> loadedResources = IGVMainFrame.getInstance().getTrackManager().getDataResourceLocators();
                loadedResources.addAll(AttributeManager.getInstance().getLoadedResources());
                if (selectedLocators != null) {
                    for (ResourceLocator locator : selectedLocators) {
                        if (locator.getPath() == null || loadedResources.contains(locator)) continue;
                        newLoadList.add(locator);
                    }
                }
                arrayList = newLoadList;
                Object var18_25 = null;
                if (!xmlParsingError) return arrayList;
            }
            catch (Exception e7) {
                log.error("Could not load information from server", e7);
                List<ResourceLocator> list = null;
                Object var18_26 = null;
                if (!xmlParsingError) return list;
                log.error(buffer.toString());
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            if (!xmlParsingError) throw throwable;
            log.error(buffer.toString());
            throw throwable;
        }
        log.error(buffer.toString());
        return arrayList;
    }

    private LinkedHashSet<URL> getResourceUrls(BufferedReader bufferedReader) throws IOException {
        String xmlFileUrl;
        LinkedHashSet<URL> xmlFileUrls = new LinkedHashSet<URL>();
        while ((xmlFileUrl = bufferedReader.readLine()) != null && xmlFileUrl.trim().length() != 0) {
            xmlFileUrl = xmlFileUrl.trim();
            xmlFileUrls.add(new URL(xmlFileUrl));
        }
        return xmlFileUrls;
    }
}

