/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.track.Track;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackFilter
extends Filter {
    private boolean showAll = false;
    List<Track> currentTrackList;

    public TrackFilter(String name, List<TrackFilterElement> elements) {
        super(name, elements);
    }

    public void clearTracks() {
        this.currentTrackList = null;
    }

    public void addTracks(List<Track> tracks) {
        if (tracks == null || tracks.isEmpty()) {
            return;
        }
        if (this.currentTrackList == null) {
            this.currentTrackList = new ArrayList<Track>(tracks);
        }
    }

    @Override
    public void evaluate() {
        if (this.currentTrackList == null || this.currentTrackList.isEmpty()) {
            return;
        }
        boolean filterEnabled = this.isEnabled();
        for (Track track : this.currentTrackList) {
            Boolean result = null;
            if (!filterEnabled) {
                track.setVisible(!filterEnabled);
                continue;
            }
            Iterator iterator = this.getFilterElements();
            while (iterator.hasNext()) {
                FilterElement element = (FilterElement)iterator.next();
                result = element.evaluate(track, result);
            }
            track.setVisible(result);
        }
    }
}

