/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import java.io.IOException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.tribble.FeatureFileHeader;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.util.LineReader;

public abstract class UCSCCodec
implements FeatureCodec {
    String[] tokens = new String[50];
    int startBase = 0;
    FeatureFileHeader header;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readHeader(LineReader reader) {
        this.header = new FeatureFileHeader();
        int nLines = 0;
        try {
            while (true) {
                String nextLine;
                if (!((nextLine = reader.readLine()) != null && (nextLine.startsWith("#") || nextLine.startsWith("track")) || nextLine.startsWith("browser"))) {
                    return this.header;
                }
                ++nLines;
                if (nextLine.startsWith("#type")) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length <= 1) continue;
                    try {
                        this.header.setTrackType(TrackType.valueOf(tokens[1]));
                    }
                    catch (Exception e2) {}
                    continue;
                }
                if (!nextLine.startsWith("track")) continue;
                TrackProperties tp = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, tp);
                this.header.setTrackProperties(tp);
            }
        }
        catch (IOException e3) {
            throw new CodecLineParsingException("Error parsing header", e3);
        }
    }

    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Class getFeatureType() {
        return BasicFeature.class;
    }
}

