/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.tribble.CachingFeatureReader;
import org.broad.igv.track.tribble.CodecFactory;
import org.broad.igv.track.tribble.VCFCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.readers.BasicFeatureReader;
import org.broad.tribble.util.CloseableTribbleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TribbleFeatureSource
implements FeatureSource {
    CachingFeatureReader reader;
    DataSource coverageSource;
    boolean isVCF;
    Map<String, String> chrNameMap = new HashMap<String, String>();
    private int binSize;
    Object header;

    public TribbleFeatureSource(String path) throws IOException {
        FeatureCodec codec = CodecFactory.getCodec(path);
        this.isVCF = codec instanceof VCFCodec;
        BasicFeatureReader basicReader = new BasicFeatureReader(path, codec);
        this.header = basicReader.getHeader();
        this.initBinSize(basicReader);
        this.reader = new CachingFeatureReader(basicReader, this.getBinSize());
        this.init();
        this.initCoverageSource(path + ".tdf");
    }

    private void initCoverageSource(String covPath) {
        if (ParsingUtils.pathExists(covPath)) {
            TDFReader reader = TDFReader.getReader(covPath);
            this.coverageSource = new TDFDataSource(reader, 0, "");
        }
    }

    private void init() {
        Set<String> seqNames;
        Genome genome = ViewContext.getInstance().getGenome();
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String seqName : seqNames) {
                String igvChr = genome.getChromosomeAlias(seqName);
                if (igvChr == null || igvChr.equals(seqName)) continue;
                this.chrNameMap.put(igvChr, seqName);
            }
        }
    }

    public CloseableIterator<org.broad.igv.feature.Feature> getFeatures(String chr, int start, int end) throws IOException {
        String seqName = this.chrNameMap.get(chr);
        if (seqName == null) {
            seqName = chr;
        }
        return this.reader.query(seqName, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return this.coverageSource == null ? null : this.coverageSource.getSummaryScoresForRange(chr, start, end, zoom);
    }

    @Override
    public int getBinSize() {
        return this.binSize;
    }

    @Override
    public void setBinSize(int size) {
        this.reader.setTileSize(size);
    }

    public Object getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initBinSize(FeatureReader reader) {
        CloseableTribbleIterator iter = null;
        try {
            block7: {
                try {
                    double mem = RuntimeUtils.getAvailableMemory();
                    iter = reader.iterator();
                    if (iter.hasNext()) {
                        int nSamples = this.isVCF ? 100 : 1000;
                        Feature firstFeature = (Feature)iter.next();
                        Feature lastFeature = (Feature)iter.next();
                        String chr = firstFeature.getChr();
                        int n2 = 1;
                        long len = 0L;
                        while (iter.hasNext() && n2 < nSamples) {
                            Feature f2 = (Feature)iter.next();
                            if (f2 == null) continue;
                            ++n2;
                            if (f2.getChr().equals(chr)) {
                                lastFeature = f2;
                                continue;
                            }
                            len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1);
                            firstFeature = f2;
                            lastFeature = f2;
                            chr = f2.getChr();
                        }
                        double dMem = mem - (double)RuntimeUtils.getAvailableMemory();
                        double bytesPerFeature = Math.max(100.0, dMem / (double)n2);
                        double featuresPerBase = (double)n2 / (double)(len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1));
                        double targetBinMemory = 1.0E7;
                        int maxBS = this.isVCF ? 1000000 : Integer.MAX_VALUE;
                        int bs = Math.min(maxBS, (int)(targetBinMemory / (bytesPerFeature * featuresPerBase)));
                        this.binSize = Math.max(100000, bs);
                        break block7;
                    }
                    this.binSize = Integer.MAX_VALUE;
                }
                catch (IOException e2) {
                    this.binSize = 1000000;
                    Object var23_19 = null;
                    if (iter == null) return;
                    iter.close();
                    return;
                }
            }
            Object var23_18 = null;
            if (iter == null) return;
            iter.close();
            return;
        }
        catch (Throwable throwable) {
            Object var23_20 = null;
            if (iter == null) throw throwable;
            iter.close();
            throw throwable;
        }
    }
}

