/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import com.jidesoft.utils.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.tools.IgvTools;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.track.WindowFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgvToolsGui
extends JDialog {
    static JFileChooser fileDialog;
    private static final String COUNT = "Count";
    private static final String SORT = "Sort";
    private static final String INDEX = "Index";
    private static final String TILE = "Tile";
    String[] tools = new String[]{"Tile", "Count", "Sort", "Index"};
    String[] zoomLevels = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    PrintStream systemOutStream;
    PrintStream systemErrStream;
    private boolean genomeSelectionDisabled = false;
    private JPanel mainPanel;
    private JPanel requiredPanel;
    private JComboBox toolCombo;
    private JLabel outputLabel;
    private JButton outputButton;
    private JTextField inputField;
    private JButton inputButton;
    private JTextField outputField;
    private JLabel genomeLabel;
    private JTextField genomeField;
    private JButton genomeButton;
    private JPanel tilePanel;
    private JLabel zoomLabel;
    private JLabel windowFunctionLabel;
    private JPanel windowFunctionPanel;
    private JCheckBox minCheckBox;
    private JCheckBox maxCheckBox;
    private JCheckBox meanCheckBox;
    private JCheckBox medianCheckBox;
    private JCheckBox a2CheckBox;
    private JCheckBox a10CheckBox;
    private JCheckBox a90CheckBox;
    private JCheckBox a98CheckBox;
    private JLabel probeLabel;
    private JTextField probeField;
    private JButton probeButton;
    private JComboBox zoomCombo;
    private JLabel windowLabel;
    private JTextField windowField;
    private JPanel sortPanel;
    private JLabel tempLabel;
    private JLabel recordLabel;
    private JButton tempButton;
    private JTextField tempField;
    private JTextField recordField;
    private JPanel buttonPanel;
    private JButton runButton;
    private JButton closeButton;
    private JPanel OutputPanel;
    private JScrollPane outputScroll;
    private JTextArea outputText;
    private JProgressBar progressBar;

    public IgvToolsGui() {
        this.initComponents();
        this.initUI();
        this.updateUI();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.this.close();
                IgvToolsGui.this.setVisible(false);
            }
        });
        this.inputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.inputField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.outputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.outputField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.genomeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.genomeField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.probeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.probeField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.toolCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.this.updateUI();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.this.run();
            }
        });
        this.tempButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.tempField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void initUI() {
        this.setContentPane(this.mainPanel);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                IgvToolsGui.this.close();
            }
        });
        for (String item : this.zoomLevels) {
            this.zoomCombo.addItem(item);
        }
        for (String tool : this.tools) {
            this.toolCombo.addItem(tool);
        }
        this.zoomCombo.setSelectedIndex(7);
        this.windowField.setText(String.valueOf(25));
        this.recordField.setText(String.valueOf(500000));
        this.redirectSystemStreams();
    }

    private void close() {
        System.setErr(this.systemErrStream);
        System.setOut(this.systemOutStream);
        this.dispose();
    }

    private void updateTextArea(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IgvToolsGui.this.outputText.append(text);
            }
        });
    }

    private void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            public void write(int b2) throws IOException {
                IgvToolsGui.this.updateTextArea(String.valueOf((char)b2));
            }

            public void write(byte[] b2, int off, int len) throws IOException {
                IgvToolsGui.this.updateTextArea(new String(b2, off, len));
            }

            public void write(byte[] b2) throws IOException {
                this.write(b2, 0, b2.length);
            }
        };
        this.systemOutStream = System.out;
        this.systemErrStream = System.err;
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    private void updateUI() {
        String tool = (String)this.toolCombo.getSelectedItem();
        if (tool.equals(COUNT)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            if (!this.genomeSelectionDisabled) {
                this.genomeField.setEnabled(true);
                this.genomeButton.setEnabled(true);
                this.genomeLabel.setEnabled(true);
            }
            this.zoomCombo.setEnabled(true);
            this.zoomLabel.setEnabled(true);
            this.recordField.setEnabled(false);
            this.recordLabel.setEnabled(false);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tempLabel.setEnabled(false);
            this.tempField.setEnabled(false);
            this.tempButton.setEnabled(false);
            this.windowLabel.setEnabled(true);
            this.windowField.setEnabled(true);
            this.enableWindowFunctions();
        } else if (tool.equals(SORT)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            this.genomeField.setEnabled(false);
            this.genomeButton.setEnabled(false);
            this.genomeLabel.setEnabled(false);
            this.zoomCombo.setEnabled(false);
            this.zoomLabel.setEnabled(false);
            this.recordField.setEnabled(true);
            this.recordLabel.setEnabled(true);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tempLabel.setEnabled(true);
            this.tempField.setEnabled(true);
            this.tempButton.setEnabled(true);
            this.windowLabel.setEnabled(false);
            this.windowField.setEnabled(false);
            this.disableWindowFunctions();
        } else if (tool.equals(INDEX)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(false);
            this.outputButton.setEnabled(false);
            this.outputLabel.setEnabled(false);
            this.genomeField.setEnabled(false);
            this.genomeButton.setEnabled(false);
            this.genomeLabel.setEnabled(false);
            this.zoomCombo.setEnabled(false);
            this.zoomLabel.setEnabled(false);
            this.recordField.setEnabled(false);
            this.recordLabel.setEnabled(false);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tempLabel.setEnabled(false);
            this.tempField.setEnabled(false);
            this.tempButton.setEnabled(false);
            this.windowLabel.setEnabled(false);
            this.windowField.setEnabled(false);
            this.disableWindowFunctions();
        } else if (tool.equals(TILE)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            if (!this.genomeSelectionDisabled) {
                this.genomeField.setEnabled(true);
                this.genomeButton.setEnabled(true);
                this.genomeLabel.setEnabled(true);
            }
            this.zoomCombo.setEnabled(true);
            this.zoomLabel.setEnabled(true);
            this.recordField.setEnabled(false);
            this.recordLabel.setEnabled(false);
            this.probeField.setEnabled(true);
            this.probeButton.setEnabled(true);
            this.probeLabel.setEnabled(true);
            this.tempLabel.setEnabled(false);
            this.tempField.setEnabled(false);
            this.tempButton.setEnabled(false);
            this.windowLabel.setEnabled(false);
            this.windowField.setEnabled(false);
            this.enableWindowFunctions();
        }
    }

    private void enableWindowFunctions() {
        Component[] com = this.windowFunctionPanel.getComponents();
        this.windowFunctionLabel.setEnabled(true);
        for (int i2 = 0; i2 < com.length; ++i2) {
            com[i2].setEnabled(true);
        }
    }

    private void disableWindowFunctions() {
        Component[] com = this.windowFunctionPanel.getComponents();
        this.windowFunctionLabel.setEnabled(false);
        for (int i2 = 0; i2 < com.length; ++i2) {
            com[i2].setEnabled(false);
        }
    }

    private boolean validateFields() {
        int opt;
        String tool = (String)this.toolCombo.getSelectedItem();
        if (this.inputField.getText().trim().length() == 0) {
            this.showMessage("Input file is required");
            return false;
        }
        if (tool.equals(INDEX)) {
            return true;
        }
        if (this.outputField.getText().trim().length() == 0) {
            this.showMessage("Output file is required");
            return false;
        }
        if (new File(this.outputField.getText().trim()).exists() && (opt = JOptionPane.showConfirmDialog(this, "Output file: " + this.outputField.getText() + " exists.  Overwite?")) != 0) {
            return false;
        }
        if (tool.equals(SORT)) {
            return true;
        }
        if (this.genomeField.getText().trim().length() == 0) {
            this.showMessage("Genome is required");
            return false;
        }
        return true;
    }

    private void run() {
        String tool = (String)this.toolCombo.getSelectedItem();
        if (!this.validateFields()) {
            return;
        }
        try {
            if (tool.equals(COUNT)) {
                this.doCount();
            } else if (tool.equals(SORT)) {
                this.doSort();
            } else if (tool.equals(INDEX)) {
                this.doIndex();
            } else if (tool.equals(TILE)) {
                this.doTile();
            }
        }
        catch (PreprocessingException e2) {
            this.showMessage("Error performing " + tool + ": " + e2.getMessage());
        }
    }

    private void showMessage(String tool) {
        JOptionPane.showMessageDialog(this, tool);
    }

    private void doSort() {
        this.runButton.setEnabled(false);
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String maxRecordText = IgvToolsGui.this.recordField.getText();
                    int maxRecords = maxRecordText != null && maxRecordText.length() > 0 ? Integer.parseInt(maxRecordText) : 500000;
                    IgvTools.doSort(IgvToolsGui.this.inputField.getText(), IgvToolsGui.this.outputField.getText(), IgvToolsGui.this.tempField.getText(), maxRecords);
                }
                catch (Exception e2) {
                    IgvToolsGui.this.showMessage("Error: " + e2.getMessage());
                }
                return null;
            }

            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doCount() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    String ofile = IgvToolsGui.this.outputField.getText();
                    String genomeId = IgvToolsGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(IgvToolsGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = IgvToolsGui.this.getWindowFunctions();
                    String windowSizeText = IgvToolsGui.this.windowField.getText();
                    int windowSize = windowSizeText != null && windowSizeText.length() > 0 ? Integer.parseInt(windowSizeText) : 25;
                    int extFactor = 0;
                    int strandOption = -1;
                    IgvToolsGui.this.runButton.setEnabled(false);
                    IgvTools.doCount(ifile, ofile, genomeId, maxZoomValue, wfs, windowSize, extFactor, strandOption);
                }
                catch (Exception e2) {
                    IgvToolsGui.this.showMessage("Error: " + e2.getMessage());
                }
                return null;
            }

            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doTile() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    String ofile = IgvToolsGui.this.outputField.getText();
                    String genomeId = IgvToolsGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(IgvToolsGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = IgvToolsGui.this.getWindowFunctions();
                    String probeFile = IgvToolsGui.this.probeField.getText();
                    IgvToolsGui.this.runButton.setEnabled(false);
                    IgvTools.doTile(ifile, ofile, probeFile, genomeId, maxZoomValue, wfs);
                }
                catch (Exception e2) {
                    IgvToolsGui.this.showMessage("Error: " + e2.getMessage());
                }
                return null;
            }

            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doIndex() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    int indexType = 1;
                    int binSize = 16000;
                    IgvToolsGui.this.runButton.setEnabled(false);
                    IgvTools.doIndex(ifile, indexType, binSize);
                }
                catch (Exception e2) {
                    IgvToolsGui.this.showMessage("Error: " + e2.getMessage());
                }
                return null;
            }

            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private Collection<WindowFunction> getWindowFunctions() {
        ArrayList<WindowFunction> wfs = new ArrayList<WindowFunction>();
        if (this.minCheckBox.isSelected()) {
            wfs.add(WindowFunction.min);
        }
        if (this.maxCheckBox.isSelected()) {
            wfs.add(WindowFunction.max);
        }
        if (this.meanCheckBox.isSelected()) {
            wfs.add(WindowFunction.mean);
        }
        if (this.a98CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile98);
        }
        if (this.a90CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile90);
        }
        if (this.a10CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile10);
        }
        if (this.a2CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile2);
        }
        if (wfs.isEmpty()) {
            wfs.add(WindowFunction.mean);
        }
        return wfs;
    }

    private File chooseFile() {
        if (fileDialog == null) {
            fileDialog = new JFileChooser();
        }
        fileDialog.setMultiSelectionEnabled(false);
        fileDialog.setFileSelectionMode(0);
        int returnVal = fileDialog.showDialog(this, "Select File");
        if (returnVal == 1) {
            return null;
        }
        File selected = fileDialog.getSelectedFile();
        return selected;
    }

    public static void main(String[] args) {
        IgvToolsGui.launch(true, null);
    }

    public static void launch(boolean modal, String genomeId) {
        IgvToolsGui mainWindow = new IgvToolsGui();
        mainWindow.pack();
        mainWindow.setModal(modal);
        mainWindow.setDefaultCloseOperation(2);
        mainWindow.setResizable(false);
        if (genomeId != null) {
            mainWindow.genomeField.setText(genomeId);
            mainWindow.genomeField.setEnabled(false);
            mainWindow.genomeField.setToolTipText("<html>To change the genome id close this window and <br>use the pulldown on the IGV main screen.");
            mainWindow.genomeButton.setEnabled(false);
            mainWindow.genomeSelectionDisabled = true;
        }
        mainWindow.setVisible(true);
    }

    private void inputButtonActionPerformed(ActionEvent e2) {
        this.setDefaultOutputText();
    }

    private void inputFieldActionPerformed(ActionEvent e2) {
        this.setDefaultOutputText();
    }

    private void inputFieldFocusLost(FocusEvent e2) {
        this.setDefaultOutputText();
    }

    private void setDefaultOutputText() {
        if (this.outputField.getText().length() == 0 && this.inputField.getText().length() > 0) {
            String input;
            int ext;
            String cmd = this.toolCombo.getSelectedItem().toString().toLowerCase();
            if (cmd.equals("count") || cmd.equals("tile")) {
                this.outputField.setText(this.inputField.getText() + ".tdf");
            } else if (cmd.equals("sort") && (ext = (input = this.inputField.getText()).lastIndexOf(".")) > 0) {
                String output = input.substring(0, ext) + ".sorted" + input.substring(ext);
                this.outputField.setText(output);
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.requiredPanel = new JPanel();
        this.toolCombo = new JComboBox();
        JLabel label1 = new JLabel();
        JLabel label2 = new JLabel();
        this.outputLabel = new JLabel();
        this.outputButton = new JButton();
        this.inputField = new JTextField();
        this.inputButton = new JButton();
        this.outputField = new JTextField();
        this.genomeLabel = new JLabel();
        this.genomeField = new JTextField();
        this.genomeButton = new JButton();
        this.tilePanel = new JPanel();
        this.zoomLabel = new JLabel();
        this.windowFunctionLabel = new JLabel();
        this.windowFunctionPanel = new JPanel();
        this.minCheckBox = new JCheckBox();
        this.maxCheckBox = new JCheckBox();
        this.meanCheckBox = new JCheckBox();
        this.medianCheckBox = new JCheckBox();
        this.a2CheckBox = new JCheckBox();
        this.a10CheckBox = new JCheckBox();
        this.a90CheckBox = new JCheckBox();
        this.a98CheckBox = new JCheckBox();
        this.probeLabel = new JLabel();
        this.probeField = new JTextField();
        this.probeButton = new JButton();
        this.zoomCombo = new JComboBox();
        this.windowLabel = new JLabel();
        this.windowField = new JTextField();
        this.sortPanel = new JPanel();
        this.tempLabel = new JLabel();
        this.recordLabel = new JLabel();
        this.tempButton = new JButton();
        this.tempField = new JTextField();
        this.recordField = new JTextField();
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.closeButton = new JButton();
        this.OutputPanel = new JPanel();
        this.outputScroll = new JScrollPane();
        this.outputText = new JTextArea();
        JSeparator separator1 = new JSeparator();
        this.progressBar = new JProgressBar();
        this.mainPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.mainPanel.setLayout(new GridBagLayout());
        this.requiredPanel.setLayout(new GridBagLayout());
        this.requiredPanel.add((Component)this.toolCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label1.setText("Command");
        this.requiredPanel.add((Component)label1, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        label2.setText("Input File");
        this.requiredPanel.add((Component)label2, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputLabel.setText("Output File");
        this.requiredPanel.add((Component)this.outputLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputButton.setText("Browse");
        this.requiredPanel.add((Component)this.outputButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e2) {
                IgvToolsGui.this.inputFieldFocusLost(e2);
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.this.inputFieldActionPerformed(e2);
            }
        });
        this.requiredPanel.add((Component)this.inputField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputButton.setText("Browse");
        this.inputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.this.inputButtonActionPerformed(e2);
            }
        });
        this.requiredPanel.add((Component)this.inputButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.outputField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeLabel.setToolTipText("Either a genome ID (e.g. hg18) or the full path to a .genome file.");
        this.genomeLabel.setText("Genome");
        this.requiredPanel.add((Component)this.genomeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.genomeField, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeButton.setText("Browse");
        this.requiredPanel.add((Component)this.genomeButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.requiredPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.tilePanel.setEnabled(true);
        this.tilePanel.setFont(this.tilePanel.getFont().deriveFont(2, 10.0f));
        this.tilePanel.setBorder(new TitledBorder(null, "Tile and Count Options", 4, 2));
        this.tilePanel.setLayout(new GridBagLayout());
        this.zoomLabel.setToolTipText("<html>Specifies the maximum zoom level to precompute. The default value is 7.<br>To reduce file size at the expense of Iperformance this value can be reduced.");
        this.zoomLabel.setText("Zoom Levels");
        this.tilePanel.add((Component)this.zoomLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionLabel.setToolTipText("Window functions to use for summarizing data. ");
        this.windowFunctionLabel.setText("Window Functions");
        this.tilePanel.add((Component)this.windowFunctionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionPanel.setLayout(new GridLayout(2, 0));
        this.minCheckBox.setText("Min");
        this.windowFunctionPanel.add(this.minCheckBox);
        this.maxCheckBox.setText("Max");
        this.windowFunctionPanel.add(this.maxCheckBox);
        this.meanCheckBox.setSelected(true);
        this.meanCheckBox.setText("Mean");
        this.windowFunctionPanel.add(this.meanCheckBox);
        this.medianCheckBox.setText("Median");
        this.windowFunctionPanel.add(this.medianCheckBox);
        this.a2CheckBox.setText("2%");
        this.windowFunctionPanel.add(this.a2CheckBox);
        this.a10CheckBox.setText("10%");
        this.windowFunctionPanel.add(this.a10CheckBox);
        this.a90CheckBox.setText("90%");
        this.windowFunctionPanel.add(this.a90CheckBox);
        this.a98CheckBox.setText("98%");
        this.windowFunctionPanel.add(this.a98CheckBox);
        this.tilePanel.add((Component)this.windowFunctionPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.probeLabel.setFont(this.probeLabel.getFont());
        this.probeLabel.setToolTipText("<html>Specifies a \"bed\" file to be used to map probe identifiers to locations.  This option is useful <br>when preprocessing gct files.  The bed file should contain 4 columns: chr start end name\n<br>where name is the probe name in the gct file.");
        this.probeLabel.setText("Probe to Loci Mapping");
        this.tilePanel.add((Component)this.probeLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.probeField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.probeButton.setText("Browse");
        this.tilePanel.add((Component)this.probeButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomCombo.setEditable(false);
        this.zoomCombo.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.tilePanel.add((Component)this.zoomCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowLabel.setToolTipText("The window size over which coverage computed when using the count command.  Defaults to 25 bp.");
        this.windowLabel.setText("Window Size");
        this.tilePanel.add((Component)this.windowLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.windowField, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.tilePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.sortPanel.setBorder(new TitledBorder(null, "Sort Options", 4, 2));
        this.sortPanel.setLayout(new GridBagLayout());
        this.tempLabel.setToolTipText("<html>Specify a temporary working directory.  For large input files this directory will be used to <br>store intermediate results of the sort. The default is the users temp directory.");
        this.tempLabel.setText("Temp Directory");
        this.sortPanel.add((Component)this.tempLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.recordLabel.setToolTipText("<html>The maximum number of records to keep in memory during the sort.  The default value is <br>500000.  Increase this number if you receive \"too many open files\" errors.   Decrease it if you <br>experience \"out of memory\" errors.");
        this.recordLabel.setText("Max Records");
        this.sortPanel.add((Component)this.recordLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tempButton.setText("Browse");
        this.sortPanel.add((Component)this.tempButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sortPanel.add((Component)this.tempField, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sortPanel.add((Component)this.recordField, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.sortPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runButton.setText("Run");
        this.buttonPanel.add((Component)this.runButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.closeButton.setText("Close");
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.OutputPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Messages", 4, 2));
        this.OutputPanel.setLayout(null);
        this.outputText.setEditable(false);
        this.outputText.setText("");
        this.outputText.setRows(10);
        this.outputScroll.setViewportView(this.outputText);
        this.OutputPanel.add(this.outputScroll);
        this.outputScroll.setBounds(4, 20, 881, this.outputScroll.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.OutputPanel.getComponentCount(); ++i2) {
            Rectangle bounds = this.OutputPanel.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.OutputPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.OutputPanel.setMinimumSize(preferredSize);
        this.OutputPanel.setPreferredSize(preferredSize);
        this.mainPanel.add((Component)this.OutputPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)separator1, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)this.progressBar, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

