/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.samtools.SAMFileReader;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.BAMHttpQueryReader;
import org.broad.igv.sam.reader.BAMQueryReader;
import org.broad.igv.sam.reader.BAMRemoteQueryReader;
import org.broad.igv.sam.reader.GeraldQueryReader;
import org.broad.igv.sam.reader.SamQueryTextReader;
import org.broad.igv.util.ResourceLocator;

public class SamQueryReaderFactory {
    private static Logger log = Logger.getLogger(SamQueryReaderFactory.class);

    public static AlignmentQueryReader getReader(String path, boolean cacheAndIndex) {
        return SamQueryReaderFactory.getReader(new ResourceLocator(path), cacheAndIndex);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator) {
        return SamQueryReaderFactory.getReader(locator, true);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator, boolean requireIndex) {
        String path = locator.getPath().toLowerCase();
        AlignmentQueryReader reader = null;
        String samFile = locator.getPath();
        if (path.endsWith(".sam")) {
            try {
                reader = new SamQueryTextReader(samFile, requireIndex);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else if (path.endsWith("sorted.txt") || path.endsWith(".aligned") || path.endsWith(".aligned.txt") || path.endsWith("bedz") || path.endsWith("bed") || path.endsWith("psl") || path.endsWith("pslx")) {
            reader = new GeraldQueryReader(samFile, requireIndex);
        } else if (path.endsWith(".bam")) {
            if (locator.isLocal()) {
                reader = new BAMQueryReader(new File(samFile));
            } else if (locator.getPath().toLowerCase().startsWith("http:") || locator.getPath().toLowerCase().startsWith("https:") || locator.getPath().toLowerCase().startsWith("ftp:")) {
                try {
                    URL url = new URL(locator.getPath());
                    reader = new BAMHttpQueryReader(url, requireIndex);
                }
                catch (MalformedURLException e3) {
                    log.error("", e3);
                    throw new DataLoadException("Error loading BAM file: " + e3.toString(), locator.getPath());
                }
            } else {
                reader = new BAMRemoteQueryReader(locator);
            }
        } else if (path.endsWith(".bam.list")) {
            reader = new BAMRemoteQueryReader(locator);
        } else {
            throw new RuntimeException("No reader found for alignment file: " + locator.getPath());
        }
        return reader;
    }

    static {
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
    }
}

