/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import javax.swing.JProgressBar;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.sam.reader.SamIndexCreatorDialog;
import org.broad.igv.sam.reader.SamUtils;

public class SamIndexer
extends AlignmentIndexer {
    static final int FLAG_COL = 1;
    static final int READ_UNMAPPED_FLAG = 4;

    public SamIndexer(File samFile, JProgressBar progressBar, SamIndexCreatorDialog.IndexWorker worker) {
        super(samFile, progressBar, worker);
    }

    int getAlignmentStart(String[] fields) throws NumberFormatException {
        int alignmentStart = Integer.parseInt(fields[3].trim()) - 1;
        return alignmentStart;
    }

    int getAlignmentLength(String[] fields) throws NumberFormatException {
        String cigarString = fields[5];
        return SamUtils.getPaddedReferenceLength(cigarString);
    }

    String getChromosome(String[] fields) {
        return fields[2];
    }

    boolean isMapped(String[] fields) {
        int flags = Integer.parseInt(fields[1]);
        return (flags & 4) == 0;
    }
}

