/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.PreferenceManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadGroupFilter {
    private Set<String> filteredReadGroups;
    static Map<String, ReadGroupFilter> filterCache = new HashMap<String, ReadGroupFilter>();

    private ReadGroupFilter(Set<String> filteredReadGroups) {
        this.filteredReadGroups = filteredReadGroups;
    }

    public boolean filterAlignment(Alignment alignment) {
        return this.filteredReadGroups.contains(alignment.getReadGroup());
    }

    public static synchronized ReadGroupFilter getFilter() {
        PreferenceManager.SAMPreferences samPrefs = PreferenceManager.getInstance().getSAMPreferences();
        if (samPrefs.isFilterAlignments()) {
            String filterURL = samPrefs.getFilterURL();
            ReadGroupFilter filter = filterCache.get(filterURL);
            if (filter == null) {
                HashSet<String> readGroups = new HashSet<String>();
                AsciiLineReader reader = null;
                try {
                    String nextLine;
                    reader = ParsingUtils.openAsciiReader(new ResourceLocator(filterURL));
                    while ((nextLine = reader.readLine()) != null) {
                        readGroups.add(nextLine.trim());
                    }
                    filter = new ReadGroupFilter(readGroups);
                    filterCache.put(filterURL, filter);
                }
                catch (IOException e2) {
                    MessageUtils.showMessage("Error reading read filter list: " + e2.getMessage());
                }
            }
            return filter;
        }
        return null;
    }
}

