/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureIndex {
    private int tileWidth;
    private Map<String, ChromosomeIndex> chrIndeces;
    private Logger log = Logger.getLogger(FeatureIndex.class);

    public FeatureIndex(int tileWidth) {
        this.tileWidth = tileWidth;
        this.chrIndeces = new LinkedHashMap<String, ChromosomeIndex>();
    }

    public FeatureIndex(File f2) {
        this(f2.getAbsolutePath());
    }

    public FeatureIndex(String path) {
        InputStream is = null;
        try {
            is = ParsingUtils.openInputStream(new ResourceLocator(path));
            this.chrIndeces = new LinkedHashMap<String, ChromosomeIndex>();
            this.read(is);
        }
        catch (IOException ex) {
            this.log.error("Error reading index", ex);
            throw new DataLoadException("Error reading index: " + ex.getMessage(), path);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public boolean containsChromosome(String chr) {
        return this.chrIndeces.containsKey(chr);
    }

    public Set<String> getIndexedChromosomes() {
        return this.chrIndeces.keySet();
    }

    public void add(String chr, long idx, int count, int longestFeature) {
        ChromosomeIndex chrIndex = this.chrIndeces.get(chr);
        if (chrIndex == null) {
            chrIndex = new ChromosomeIndex(longestFeature);
            this.chrIndeces.put(chr, chrIndex);
        }
        chrIndex.addTile(new TileDef(idx, count));
    }

    public TileDef getTileDef(String chr, int tile) {
        ChromosomeIndex chrIdx = this.chrIndeces.get(chr);
        if (chrIdx == null) {
            return null;
        }
        return chrIdx.getTileDefinition(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File f2) throws IOException {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f2)));
            ((DataOutputStream)dos).writeInt(this.getTileWidth());
            for (Map.Entry<String, ChromosomeIndex> entry : this.chrIndeces.entrySet()) {
                ChromosomeIndex chrIdx = entry.getValue();
                List<TileDef> tmp = chrIdx.getTileDefinitions();
                if (entry.getKey() == null) continue;
                ((DataOutputStream)dos).writeUTF(entry.getKey());
                ((DataOutputStream)dos).writeInt(tmp.size());
                ((DataOutputStream)dos).writeInt(chrIdx.getLongestFeature());
                for (int i2 = 0; i2 < tmp.size(); ++i2) {
                    TileDef tileDef = tmp.get(i2);
                    ((DataOutputStream)dos).writeLong(tileDef.getStartPosition());
                    ((DataOutputStream)dos).writeInt(tileDef.getCount());
                }
            }
        }
        finally {
            dos.close();
        }
    }

    private void read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        this.tileWidth = dis.readInt();
        try {
            while (true) {
                String chr = dis.readUTF();
                int nTiles = dis.readInt();
                int longestFeature = dis.readInt();
                ArrayList<TileDef> tileDefs = new ArrayList<TileDef>(nTiles);
                for (int tileNumber = 0; tileNumber < nTiles; ++tileNumber) {
                    long pos = dis.readLong();
                    int count = dis.readInt();
                    tileDefs.add(new TileDef(pos, count));
                }
                this.chrIndeces.put(chr, new ChromosomeIndex(longestFeature, tileDefs));
            }
        }
        catch (EOFException e2) {
        }
        catch (UTFDataFormatException e3) {
            this.log.error("Error reading chromosome name. ", e3);
        }
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getLongestFeature(String chr) {
        ChromosomeIndex tmp = this.chrIndeces.get(chr);
        if (tmp == null) {
            return 1000;
        }
        return tmp.getLongestFeature();
    }

    public static class TileDef {
        private long startPosition;
        private int count;

        public TileDef(long startPosition, int count) {
            this.startPosition = startPosition;
            this.count = count;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChromosomeIndex {
        private int longestFeature;
        private List<TileDef> tileDefinitions;

        ChromosomeIndex(int longestFeature) {
            this(longestFeature, new ArrayList<TileDef>());
        }

        public ChromosomeIndex(int longestFeature, List<TileDef> tileDefinitions) {
            this.longestFeature = longestFeature;
            this.tileDefinitions = tileDefinitions;
        }

        void addTile(TileDef tileDef) {
            this.getTileDefinitions().add(tileDef);
        }

        TileDef getTileDefinition(int i2) {
            if (this.getTileDefinitions().isEmpty()) {
                return null;
            }
            int tileNumber = Math.min(i2, this.getTileDefinitions().size() - 1);
            return this.getTileDefinitions().get(tileNumber);
        }

        public int getLongestFeature() {
            return this.longestFeature;
        }

        public List<TileDef> getTileDefinitions() {
            return this.tileDefinitions;
        }
    }
}

