/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.jidesoft.swing.JidePopupMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.DragEvent;
import org.broad.igv.ui.panel.DragListener;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentTrack
extends AbstractTrack
implements DragListener {
    public static final int MIN_ALIGNMENT_SPACING = 10;
    static final ColorOption DEFAULT_COLOR_OPTION = ColorOption.INSERT_SIZE;
    static final boolean DEFAULT_SHOWALLBASES = false;
    private static ColorOption colorByOption = null;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private RenderOptions renderOptions;
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    private int expandedHeight = 14;
    private int collapsedHeight = 2;
    private FeatureRenderer renderer;
    private double minVisibleScale = 25.0;
    private Rectangle renderedRect;
    private int minHeight = 100;
    private AlignmentDataManager dataManager;
    private HashMap<String, Color> selectedReadNames = new HashMap();
    int selectionColorIndex = 0;

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager) {
        super(locator);
        this.dataManager = dataManager;
        float maxRange = PreferenceManager.getInstance().getSAMPreferences().getMaxVisibleRange();
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
        this.renderer = new AlignmentRenderer();
        this.setExpanded(true);
        PreferenceManager.SAMPreferences prefs = PreferenceManager.getInstance().getSAMPreferences();
        if (prefs.isShowRefSequence()) {
            this.sequenceTrack = new SequenceTrack("Reference");
            this.sequenceTrack.setHeight(14);
        }
        this.renderOptions = new RenderOptions();
        if (colorByOption == null) {
            String colorByString = PreferenceManager.getInstance().getSAMPreferences().getColorBy();
            if (colorByString == null) {
                colorByOption = DEFAULT_COLOR_OPTION;
            } else {
                try {
                    colorByOption = ColorOption.valueOf(colorByString);
                }
                catch (Exception e2) {
                    log.error("Error setting color option", e2);
                    colorByOption = DEFAULT_COLOR_OPTION;
                }
            }
        }
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public void setRenderer(FeatureRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        int h2 = Math.max(this.minHeight, this.getNLevels() * this.getRowHeight() + 20);
        return h2;
    }

    private int getRowHeight() {
        return this.isExpanded() ? this.expandedHeight : this.collapsedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getAlignmentRows() == null ? 1 : this.dataManager.getAlignmentRows().size();
    }

    @Override
    public int getPreferredHeight() {
        return Math.max(100, this.getHeight());
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        int n2 = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        int gap = seqHeight > 0 ? seqHeight : 6;
        rect.y += gap;
        rect.height -= gap;
        this.renderedRect = new Rectangle(rect);
        if (context.getScale() > this.minVisibleScale) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", context.getVisibleRect(), g2);
            return;
        }
        this.renderFeatures(context, rect);
    }

    private void renderFeatures(RenderContext context, Rectangle inputRect) {
        try {
            log.debug("Render features");
            String genomeId = context.getGenomeId();
            String chr = context.getChr();
            int start = (int)context.getOrigin();
            int end = (int)context.getEndLocation() + 1;
            List<AlignmentInterval.Row> tmp = this.dataManager.getAlignmentRows(genomeId, chr, start, end);
            if (tmp == null) {
                return;
            }
            Rectangle visibleRect = context.getVisibleRect();
            double y = inputRect.getY();
            double h2 = this.expandedHeight;
            if (!this.isExpanded()) {
                int visHeight = context.getVisibleRect().height;
                this.collapsedHeight = Math.max(1, Math.min(this.expandedHeight, visHeight / this.dataManager.getMaxDepth()));
                h2 = this.collapsedHeight;
            }
            int levelNumber = 0;
            for (AlignmentInterval.Row row : tmp) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                if (y + h2 > visibleRect.getY()) {
                    Rectangle rect = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h2);
                    this.renderOptions.setColorOption(colorByOption);
                    this.renderer.renderAlignments(row.alignments, context, rect, this.renderOptions, this.isExpanded(), this.selectedReadNames);
                }
                y += h2;
                ++levelNumber;
            }
        }
        catch (Exception ex) {
            log.error("Error rendering track", ex);
            throw new RuntimeException("Error rendering track ", ex);
        }
    }

    public void reloadData() {
        float maxRange = PreferenceManager.getInstance().getSAMPreferences().getMaxVisibleRange();
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
        this.renderOptions = new RenderOptions();
        this.dataManager.reload();
    }

    public void sortRows(SortOption option) {
        this.dataManager.sortRows(option);
    }

    public void sortRows(SortOption option, double location) {
        this.dataManager.sortRows(option, location);
    }

    public void packAlignments() {
        this.dataManager.packAlignments();
    }

    public void copyToClipboard(MouseEvent e2) {
        double location = this.getViewContext().getChromosomePosition(e2.getX());
        double displayLocation = location + 1.0;
        Alignment alignment = this.getAlignmentAt(displayLocation, e2.getY());
        if (alignment != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(alignment.getValueString(location, null).replace("<br>", "\n"));
            buf.append("\n");
            buf.append("Alignment start position = " + alignment.getChr() + ":" + (alignment.getAlignmentStart() + 1));
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void gotoMate(MouseEvent e2) {
        ReadMate mate;
        double location = this.getViewContext().getChromosomePosition(e2.getX());
        double displayLocation = location + 1.0;
        Alignment alignment = this.getAlignmentAt(displayLocation, e2.getY());
        if (alignment != null && (mate = alignment.getMate()) != null && mate.isMapped()) {
            String chr = mate.getMateChr();
            int start = mate.mateStart - 1;
            ViewContext.getInstance().centerOnLocation(chr, start);
            ViewContext.getInstance().recordHistory();
        }
    }

    @Override
    public void setStatType(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y) {
        Alignment feature = this.getAlignmentAt(position, y);
        String tmp = feature == null ? null : feature.getValueString(position, this.getWindowFunction());
        return tmp;
    }

    private Alignment getAlignmentAt(double position, int y) {
        if (this.dataManager.getAlignmentRows() == null || this.dataManager.getAlignmentRows().isEmpty()) {
            return null;
        }
        int h2 = this.isExpanded() ? this.expandedHeight : this.collapsedHeight;
        int levelNumber = (y - this.renderedRect.y) / h2;
        if (levelNumber < 0 || levelNumber >= this.dataManager.getAlignmentRows().size()) {
            return null;
        }
        AlignmentInterval.Row row = this.dataManager.getAlignmentRows().get(levelNumber);
        List<Alignment> features = row.alignments;
        double bpPerPixel = ViewContext.getInstance().getScale();
        double minWidth = 2.0 * bpPerPixel;
        return (Alignment)FeatureUtils.getFeatureAt(position, minWidth, features);
    }

    @Override
    public void dragStopped(DragEvent evt) {
    }

    private static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f2 = features.get(idx);
            if (f2.contains(right)) {
                return f2;
            }
            if (f2.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    @Override
    public boolean handleClick(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.getPopupMenu(e2).show(e2.getComponent(), e2.getX(), e2.getY());
            return true;
        }
        if (e2.isShiftDown() || e2.isAltDown() || e2.getClickCount() > 1) {
            return super.handleClick(e2);
        }
        if (e2.getButton() == 1 && (UIConstants.IS_MAC && e2.isMetaDown() || !UIConstants.IS_MAC && e2.isControlDown())) {
            double location = this.getViewContext().getChromosomePosition(e2.getX());
            double displayLocation = location + 1.0;
            Alignment alignment = this.getAlignmentAt(displayLocation, e2.getY());
            if (alignment != null) {
                if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                    this.selectedReadNames.remove(alignment.getReadName());
                } else {
                    Color c2 = alignment.isPaired() && alignment.getMate() != null && alignment.getMate().isMapped() ? ColorUtilities.randomColor(this.selectionColorIndex++) : Color.black;
                    this.selectedReadNames.put(alignment.getReadName(), c2);
                }
                Object source = e2.getSource();
                if (source instanceof JComponent) {
                    ((JComponent)source).repaint();
                }
            }
            return true;
        }
        return false;
    }

    public JPopupMenu getPopupMenu(MouseEvent evt) {
        JidePopupMenu popupMenu = new JidePopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        this.addSortMenuItem(popupMenu);
        this.addPackMenuItem(popupMenu);
        this.addCoverageDepthMenuItem(popupMenu);
        popupMenu.addSeparator();
        this.addColorByMenuItem(popupMenu);
        this.addShadeBaseMenuItem(popupMenu);
        this.addShadeCentersMenuItem(popupMenu);
        this.addGoToMate(popupMenu, evt);
        this.addShowAllBasesMenuItem(popupMenu);
        this.addInsertSizeMenuItem(popupMenu);
        popupMenu.addSeparator();
        this.addShowCoverageItem(popupMenu);
        this.addLoadCoverageDataItem(popupMenu);
        this.addCopyToClipboardItem(popupMenu, evt);
        popupMenu.addSeparator();
        this.addSelecteByNameItem(popupMenu);
        popupMenu.addSeparator();
        JLabel trackSettingsHeading = new JLabel("  Track Settings", 2);
        trackSettingsHeading.setFont(newFont);
        popupMenu.add(trackSettingsHeading);
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        popupMenu.add(TrackMenuUtils.getExpandCollapseItem(tmp));
        popupMenu.add(TrackMenuUtils.getRemoveMenuItem(tmp));
        popupMenu.addSeparator();
        this.addClearSelectionsMenuItem(popupMenu);
        return popupMenu;
    }

    public void addSelecteByNameItem(JPopupMenu menu) {
        JMenuItem item = new JMenuItem("Select by name...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                String val = MessageUtils.showInputDialog("Enter read name: ");
                if (val != null && val.trim().length() > 0) {
                    AlignmentTrack.this.selectedReadNames.put(val, ColorUtilities.randomColor(AlignmentTrack.this.selectedReadNames.size() + 1));
                    AlignmentTrack.this.refresh();
                }
            }
        });
        menu.add(item);
    }

    public void addSortMenuItem(JPopupMenu menu) {
        JMenu item = new JMenu("Sort alignments");
        JMenuItem m1 = new JMenuItem("by start location");
        m1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.START);
                AlignmentTrack.this.refresh();
            }
        });
        JMenuItem m2 = new JMenuItem("by strand");
        m2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.STRAND);
                AlignmentTrack.this.refresh();
            }
        });
        JMenuItem m3 = new JMenuItem("by base");
        m3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.NUCELOTIDE);
                AlignmentTrack.this.refresh();
            }
        });
        JMenuItem m4 = new JMenuItem("by mapping quality");
        m4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.QUALITY);
                AlignmentTrack.this.refresh();
            }
        });
        JMenuItem m5 = new JMenuItem("by sample");
        m5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.SAMPLE);
                AlignmentTrack.this.refresh();
            }
        });
        JMenuItem m6 = new JMenuItem("by read group");
        m6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortAlignmentTracks(SortOption.READ_GROUP);
                AlignmentTrack.this.refresh();
            }
        });
        if (ViewContext.getInstance().getScale() >= 10.0) {
            item.setEnabled(false);
        }
        item.add(m1);
        item.add(m2);
        item.add(m3);
        item.add(m4);
        item.add(m5);
        item.add(m6);
        menu.add(item);
    }

    private void setColorOption(ColorOption option) {
        colorByOption = option;
        PreferenceManager.getInstance().put("SAM.COLOR_BY", option.toString());
        PreferenceManager.getInstance().updateSAMPreferences();
    }

    public void addColorByMenuItem(JPopupMenu menu) {
        JMenu item = new JMenu("Color alignments");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("by insert size");
        m1.setSelected(colorByOption == ColorOption.INSERT_SIZE);
        m1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.INSERT_SIZE);
                AlignmentTrack.this.refresh();
            }
        });
        JRadioButtonMenuItem m1a = new JRadioButtonMenuItem("by pair orientation");
        m1a.setSelected(colorByOption == ColorOption.PAIR_ORIENTATION);
        m1a.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.PAIR_ORIENTATION);
                AlignmentTrack.this.refresh();
            }
        });
        JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("by read strand");
        m2.setSelected(colorByOption == ColorOption.READ_STRAND);
        m2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.READ_STRAND);
                AlignmentTrack.this.refresh();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("by first-in-pair read strand");
        m3.setSelected(colorByOption == ColorOption.FRAGMENT_STRAND);
        m3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.FRAGMENT_STRAND);
                AlignmentTrack.this.refresh();
            }
        });
        JRadioButtonMenuItem m4 = new JRadioButtonMenuItem("by read group");
        m4.setSelected(colorByOption == ColorOption.READ_GROUP);
        m4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.READ_GROUP);
                AlignmentTrack.this.refresh();
            }
        });
        JRadioButtonMenuItem m5 = new JRadioButtonMenuItem("by sample");
        m5.setSelected(colorByOption == ColorOption.SAMPLE);
        m5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.setColorOption(ColorOption.SAMPLE);
                AlignmentTrack.this.refresh();
            }
        });
        item.add(m1);
        item.add(m1a);
        item.add(m2);
        item.add(m3);
        item.add(m5);
        item.add(m4);
        group.add(m1);
        group.add(m1a);
        group.add(m2);
        group.add(m3);
        group.add(m5);
        group.add(m4);
        menu.add(item);
    }

    public void addPackMenuItem(JPopupMenu menu) {
        JMenuItem item = new JMenuItem("Re-pack alignments");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        IGVMainFrame.getInstance().getTrackManager().packAlignmentTracks();
                        AlignmentTrack.this.refresh();
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addCopyToClipboardItem(JPopupMenu menu, final MouseEvent me) {
        JMenuItem item = new JMenuItem("Copy read details to clipboard");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        AlignmentTrack.this.copyToClipboard(me);
                    }
                });
            }
        });
        if (ViewContext.getInstance().getScale() >= 10.0) {
            item.setEnabled(false);
        }
        menu.add(item);
    }

    public void addGoToMate(JPopupMenu menu, final MouseEvent me) {
        JMenuItem item = new JMenuItem("Go to mate");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlignmentTrack.this.gotoMate(me);
            }
        });
        menu.add(item);
    }

    public void addClearSelectionsMenuItem(JPopupMenu menu) {
        JMenuItem item = new JMenuItem("Clear selections");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        AlignmentTrack.this.selectedReadNames.clear();
                        AlignmentTrack.this.selectionColorIndex = 0;
                        AlignmentTrack.this.refresh();
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addShowAllBasesMenuItem(JPopupMenu menu) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
        item.setSelected(this.renderOptions.isShowAllBases());
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        AlignmentTrack.this.renderOptions.setShowAllBases(item.isSelected());
                        AlignmentTrack.this.refresh();
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addCoverageDepthMenuItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set maximum read depth ...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                int maxLevels = AlignmentTrack.this.dataManager.getMaxLevels();
                String val = MessageUtils.showInputDialog("Maximum read depth", String.valueOf(maxLevels));
                try {
                    int newMaxLevels = Integer.parseInt(val);
                    if (newMaxLevels != maxLevels) {
                        AlignmentTrack.this.dataManager.setMaxLevels(newMaxLevels);
                        AlignmentTrack.this.dataManager.reload();
                        AlignmentTrack.this.refresh();
                    }
                }
                catch (NumberFormatException ex) {
                    MessageUtils.showMessage("Insert size must be an integer value: " + val);
                }
            }
        });
        menu.add(item);
    }

    public void addInsertSizeMenuItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size threshold ...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                int threshold = AlignmentTrack.this.renderOptions.getInsertSizeThreshold();
                String val = MessageUtils.showInputDialog("insert size threshold", String.valueOf(threshold));
                try {
                    int newThreshold = Integer.parseInt(val);
                    if (newThreshold != threshold) {
                        AlignmentTrack.this.renderOptions.setInsertSizeThreshold(newThreshold);
                        AlignmentTrack.this.refresh();
                    }
                }
                catch (NumberFormatException ex) {
                    MessageUtils.showMessage("Insert size must be an integer value: " + val);
                }
            }
        });
        menu.add(item);
    }

    private void refresh() {
        IGVMainFrame.getInstance().repaintDataPanels();
    }

    public void addShadeBaseMenuItem(JPopupMenu menu) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
        item.setSelected(this.renderOptions.isShadeBases());
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        AlignmentTrack.this.renderOptions.setShadeBases(item.isSelected());
                        AlignmentTrack.this.refresh();
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addShadeCentersMenuItem(JPopupMenu menu) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade alignments intersecting center");
        item.setSelected(this.renderOptions.isShadeCenters());
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        AlignmentTrack.this.renderOptions.setShadeCenters(item.isSelected());
                        AlignmentTrack.this.refresh();
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addShowCoverageItem(JPopupMenu menu) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show coverage track");
        item.setSelected(this.getCoverageTrack() != null && this.getCoverageTrack().isVisible());
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        if (AlignmentTrack.this.getCoverageTrack() != null) {
                            AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                            AlignmentTrack.this.refresh();
                            IGVMainFrame.getInstance().repaintNamePanels();
                        }
                    }
                });
            }
        });
        menu.add(item);
    }

    public void addLoadCoverageDataItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        FileChooserDialog trackFileDialog = IGVMainFrame.getInstance().getTrackFileChooser();
                        trackFileDialog.setMultiSelectionEnabled(false);
                        trackFileDialog.setVisible(true);
                        if (!trackFileDialog.isCanceled()) {
                            File file = trackFileDialog.getSelectedFile();
                            String path = file.getAbsolutePath();
                            if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                                TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                                TDFDataSource ds = new TDFDataSource(reader, 0, AlignmentTrack.this.getName() + " coverage");
                                AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                AlignmentTrack.this.refresh();
                            } else {
                                MessageUtils.showMessage("Coverage data must be in .tdf format");
                            }
                        }
                    }
                });
            }
        });
        menu.add(item);
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attrs = super.getPersistentState();
        attrs.putAll(this.renderOptions.getPersistentState());
        return attrs;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        this.renderOptions.restorePersistentState(attributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenderOptions {
        private boolean changedByUser = false;
        private boolean shadeBases;
        private boolean shadeCenters;
        private boolean flagUnmappedPairs;
        private boolean showAllBases;
        private int insertSizeThreshold;
        private ColorOption colorOption;

        RenderOptions() {
            PreferenceManager.SAMPreferences prefs = PreferenceManager.getInstance().getSAMPreferences();
            this.shadeBases = prefs.isShadeBaseQuality();
            this.shadeCenters = prefs.isShadeCenter();
            this.flagUnmappedPairs = prefs.isFlagUnmappedPair();
            this.insertSizeThreshold = prefs.getInsertSizeThreshold();
            this.showAllBases = false;
            this.colorOption = colorByOption;
        }

        public Map<String, String> getPersistentState() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            PreferenceManager.SAMPreferences prefs = PreferenceManager.getInstance().getSAMPreferences();
            if (this.isShadeBases() != prefs.isShadeBaseQuality()) {
                attributes.put("shadeBases", String.valueOf(this.isShadeBases()));
            }
            if (this.isShadeCenters() != prefs.isShadeCenter()) {
                attributes.put("shadeCenters", String.valueOf(this.isShadeBases()));
            }
            if (this.isFlagUnmappedPairs() != prefs.isFlagUnmappedPair()) {
                attributes.put("flagUnmappedPairs", String.valueOf(this.isFlagUnmappedPairs()));
            }
            if (this.getInsertSizeThreshold() != prefs.getInsertSizeThreshold()) {
                attributes.put("insertSizeThreshold", String.valueOf(this.getInsertSizeThreshold()));
            }
            if (this.isShowAllBases()) {
                attributes.put("showAllBases", String.valueOf(this.isShowAllBases()));
            }
            if (this.getColorOption() != DEFAULT_COLOR_OPTION) {
                attributes.put("colorOption", colorByOption.toString());
            }
            return attributes;
        }

        public void restorePersistentState(Map<String, String> attributes) {
            String value = attributes.get("insertSizeThreshold");
            if (value != null) {
                this.setInsertSizeThreshold(Integer.parseInt(value));
            }
            if ((value = attributes.get("shadeBases")) != null) {
                this.setShadeBases(Boolean.parseBoolean(value));
            }
            if ((value = attributes.get("shadeCenters")) != null) {
                this.setShadeCenters(Boolean.parseBoolean(value));
            }
            if ((value = attributes.get("flagUnmappedPairs")) != null) {
                this.setFlagUnmappedPairs(Boolean.parseBoolean(value));
            }
            if ((value = attributes.get("showAllBases")) != null) {
                this.setShowAllBases(Boolean.parseBoolean(value));
            }
            if ((value = attributes.get("colorOption")) != null) {
                this.setColorOption(ColorOption.valueOf(value));
                colorByOption = this.getColorOption();
            }
        }

        public boolean isShadeBases() {
            return this.shadeBases;
        }

        public void setShadeBases(boolean shadeBases) {
            this.changedByUser = true;
            this.shadeBases = shadeBases;
        }

        public boolean isShadeCenters() {
            return this.shadeCenters;
        }

        public void setShadeCenters(boolean shadeCenters) {
            this.changedByUser = true;
            this.shadeCenters = shadeCenters;
        }

        public boolean isFlagUnmappedPairs() {
            return this.flagUnmappedPairs;
        }

        public void setFlagUnmappedPairs(boolean flagUnmappedPairs) {
            this.changedByUser = true;
            this.flagUnmappedPairs = flagUnmappedPairs;
        }

        public boolean isShowAllBases() {
            return this.showAllBases;
        }

        public void setShowAllBases(boolean showAllBases) {
            this.changedByUser = true;
            this.showAllBases = showAllBases;
        }

        public int getInsertSizeThreshold() {
            return this.insertSizeThreshold;
        }

        public void setInsertSizeThreshold(int insertSizeThreshold) {
            this.changedByUser = true;
            this.insertSizeThreshold = insertSizeThreshold;
        }

        public ColorOption getColorOption() {
            return this.colorOption;
        }

        public void setColorOption(ColorOption colorOption) {
            this.changedByUser = true;
            this.colorOption = colorOption;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FRAGMENT_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOption {
        START,
        STRAND,
        NUCELOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP;

    }
}

