/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Feature;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.util.ColorTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosmicFeatureRenderer
extends FeatureRenderer {
    private static Logger log = Logger.getLogger(CosmicFeatureRenderer.class);
    ColorTable colorScheme = PreferenceManager.getInstance().getMutationColorScheme();
    static Font font = FontManager.getScalableFont(12);

    public String getDisplayName() {
        return "Mutation";
    }

    @Override
    public void renderFeatures(List<Feature> featureList, RenderContext context, Rectangle trackRectangle, FeatureTrack track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && featureList.size() > 0) {
            Rectangle lastRect = null;
            for (Feature feature : featureList) {
                double pixelStart = Math.round(((double)feature.getStart() - origin) / locScale);
                double pixelEnd = Math.round(((double)feature.getEnd() - origin) / locScale);
                if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                int width = (int)pixelEnd - (int)pixelStart;
                if (width < 3) {
                    width = 3;
                }
                int mutHeight = (int)Math.max(1.0, trackRectangle.getHeight() - 2.0);
                int mutY = (int)(trackRectangle.getY() + (trackRectangle.getHeight() - (double)mutHeight) / 2.0);
                Rectangle mutRect = new Rectangle((int)pixelStart, mutY, width, mutHeight);
                Color color = this.colorScheme.get(feature.getType());
                Graphics2D g2 = context.getGraphic2DForColor(color);
                g2.setFont(font);
                if (this.getOverlayMode()) {
                    g2.draw(mutRect);
                    --mutRect.x;
                    mutRect.width += 2;
                    g2.draw(mutRect);
                } else {
                    g2.fill(mutRect);
                    if (lastRect != null && mutRect.intersects(lastRect)) {
                        Graphics2D g22 = context.getGraphic2DForColor(Color.BLACK);
                        g22.draw(mutRect);
                    }
                }
                lastRect = mutRect;
            }
        }
    }
}

