/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeDescriptor;
import org.broad.igv.feature.GenomeImporter;
import org.broad.igv.feature.GenomeResourceDescriptor;
import org.broad.igv.feature.GenomeServerException;
import org.broad.igv.feature.GenomeZipDescriptor;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomeManager {
    public static final String SEQUENCE_FILE_EXTENSION = ".txt";
    public static final long GENOME_REFRESH_FREQ = 604800L;
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static GenomeManager theInstance = null;
    private Map<String, GenomeDescriptor> genomeDescriptorMap = new HashMap<String, GenomeDescriptor>();
    private Map<String, Genome> genomes = new Hashtable<String, Genome>();
    private Map<String, String> aliasTable;
    public static final String ALIAS_URL = "http://www.broadinstitute.org/igvdata/genomes/alias.txt";
    public static final String USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    private static GenomeDescriptor DEFAULT_GENOME;
    File GENOME_CACHE_DIRECTORY = UIConstants.getGenomeCacheDirectory();
    private LinkedHashSet<GenomeListItem> userDefinedGenomeArchiveList;
    private LinkedHashSet<GenomeListItem> cachedGenomeArchiveList;
    private LinkedHashSet<GenomeListItem> serverGenomeArchiveList;
    boolean serverGenomeListUnreachable = false;

    private GenomeManager() {
    }

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    public Genome getGenome(String id) {
        Genome genome;
        if (log.isDebugEnabled()) {
            log.debug("Enter getGenome: " + id);
        }
        if ((genome = this.genomes.get(id)) == null) {
            GenomeDescriptor genomeDescriptor = this.genomeDescriptorMap.get(id);
            if (genomeDescriptor == null) {
                return null;
            }
            genome = this.loadGenome(genomeDescriptor);
            log.info("Genome loaded");
            this.genomes.put(id, genome);
        }
        return genome;
    }

    private Genome loadGenome(GenomeDescriptor genomeDescriptor) {
        InputStream is = null;
        try {
            BufferedReader reader;
            InputStream inputStream = genomeDescriptor.getCytoBandStream();
            if (inputStream == null) {
                Genome genome = null;
                return genome;
            }
            if (genomeDescriptor.isCytoBandFileGZipFormat()) {
                is = new GZIPInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader(is));
            } else {
                is = new BufferedInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader(is));
            }
            Genome genome = new Genome(genomeDescriptor.getId());
            LinkedHashMap<String, Chromosome> chromMap = CytoBandFileParser.loadData(reader);
            genome.setChromosomeMap(chromMap, genomeDescriptor.isChromosomesAreOrdered());
            Genome genome2 = genome;
            return genome2;
        }
        catch (IOException ex) {
            log.warn("Error loading the genome!", ex);
            throw new RuntimeException("Error loading genome: " + genomeDescriptor.getName());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    public GenomeListItem loadGenomeFromLocalFile(File zipFile) {
        GenomeListItem genomeListItem = null;
        try {
            boolean isUserDefined = false;
            File parentFolder = zipFile.getParentFile();
            if (parentFolder == null || !parentFolder.equals(this.GENOME_CACHE_DIRECTORY)) {
                isUserDefined = true;
            }
            GenomeDescriptor genomeDescriptor = this.createGenomeDescriptor(zipFile, isUserDefined);
            this.genomeDescriptorMap.put(genomeDescriptor.getId(), genomeDescriptor);
            genomeListItem = new GenomeListItem(genomeDescriptor.getName(), genomeDescriptor.getSequenceLocation(), genomeDescriptor.getId(), genomeDescriptor.getVersion(), isUserDefined);
        }
        catch (Exception e2) {
            log.warn("Error loading genome archive: " + zipFile, e2);
        }
        return genomeListItem;
    }

    public boolean isGenomeLoaded(String id) {
        return this.genomeDescriptorMap.get(id) != null;
    }

    public void findGenomeAndLoad(String genome) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Enter findGenomeAndLoad: " + genome);
        }
        LinkedHashSet<GenomeListItem> genomes = this.getAllGenomeArchives();
        for (GenomeListItem item : genomes) {
            if (!item.getId().equalsIgnoreCase(genome)) continue;
            String url = item.getLocation();
            if (this.isGenomeLoaded(item.getId())) break;
            this.loadGenome(url, item.isUserDefined(), null);
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit findGenomeAndLoad");
        }
    }

    public void loadGenome(GenomeListItem item, boolean isUserDefined) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Enter loadGenome");
        }
        if (this.isGenomeLoaded(item.getId())) {
            return;
        }
        this.loadGenome(item.getLocation(), isUserDefined, null);
    }

    public GenomeListItem loadGenome(String genomeArchiveFileLocation, boolean isUserDefined, ProgressMonitor monitor) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Enter loadGenome");
        }
        GenomeListItem genomeListItem = null;
        if (genomeArchiveFileLocation == null) {
            return this.getDefaultGenomeListItem();
        }
        if (!genomeArchiveFileLocation.trim().endsWith(".genome")) {
            throw new RuntimeException("The extension of archive [" + genomeArchiveFileLocation + "] is not an IGV genome archive extension");
        }
        try {
            File archiveFile;
            if (!isUserDefined) {
                if (!this.GENOME_CACHE_DIRECTORY.exists()) {
                    this.GENOME_CACHE_DIRECTORY.mkdir();
                }
                if (genomeArchiveFileLocation.toLowerCase().startsWith("http:") || genomeArchiveFileLocation.toLowerCase().startsWith("https:") || genomeArchiveFileLocation.toLowerCase().startsWith("file:")) {
                    URL genomeArchiveURL = new URL(genomeArchiveFileLocation);
                    String fileName = Utilities.getFileNameFromURL(URLDecoder.decode(new URL(genomeArchiveFileLocation).getFile(), "UTF-8"));
                    archiveFile = new File(this.GENOME_CACHE_DIRECTORY, fileName);
                    this.refreshCache(archiveFile, genomeArchiveURL);
                } else {
                    archiveFile = new File(genomeArchiveFileLocation);
                }
                if (monitor != null) {
                    monitor.fireProgressChange(25);
                }
                if (!archiveFile.exists()) {
                    throw new FileNotFoundException(genomeArchiveFileLocation);
                }
            } else {
                String record;
                archiveFile = new File(genomeArchiveFileLocation);
                if (!archiveFile.exists()) {
                    throw new FileNotFoundException(genomeArchiveFileLocation);
                }
                File userDefinedListFile = new File(this.GENOME_CACHE_DIRECTORY, USER_DEFINED_GENOME_LIST_FILE);
                Properties listProperties = GenomeManager.retrieveUserDefinedGenomeListFromFile(userDefinedListFile);
                if (listProperties == null) {
                    listProperties = new Properties();
                }
                if ((record = this.buildClientSideGenomeListRecord(archiveFile, isUserDefined)) != null) {
                    int version = 0;
                    String[] fields = record.split("\t");
                    listProperties.setProperty(fields[2], record);
                    GenomeImporter.storeUserDefinedGenomeListToFile(userDefinedListFile, listProperties);
                    genomeListItem = new GenomeListItem(fields[0], fields[1], fields[2], version, isUserDefined);
                }
            }
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            this.loadGenomeFromLocalFile(archiveFile);
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
        }
        catch (MalformedURLException e2) {
            log.warn("Error Importing Genome!", e2);
        }
        catch (FileNotFoundException e3) {
            throw e3;
        }
        catch (SocketException e4) {
            throw new GenomeServerException("Server connection error", e4);
        }
        catch (IOException e5) {
            log.warn("Error Importing Genome!", e5);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit loadGenome");
        }
        return genomeListItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCache(File archiveFile, URL genomeArchiveURL) {
        InputStream is = null;
        try {
            if (archiveFile.exists()) {
                boolean forceUpdate;
                boolean bl = forceUpdate = (System.currentTimeMillis() - archiveFile.lastModified()) / 1000L > 604800L;
                if (forceUpdate) {
                    log.info("Refreshing genome: " + genomeArchiveURL.toString());
                    File tmpFile = new File(archiveFile.getAbsolutePath() + ".tmp");
                    is = IGVHttpUtils.openConnectionStream(genomeArchiveURL);
                    FileUtils.createFileFromStream(is, tmpFile);
                    FileUtils.copyFile(tmpFile, archiveFile);
                    tmpFile.deleteOnExit();
                }
            } else {
                is = IGVHttpUtils.openConnectionStream(genomeArchiveURL);
                FileUtils.createFileFromStream(is, archiveFile);
            }
        }
        catch (Exception e2) {
            log.error("Error refreshing genome cache. ", e2);
            MessageUtils.showMessage("An error was encountered refreshing the genome cache: " + e2.getMessage() + "<br> If this problem persists please contact igv-help@broadinstitute.org");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {
                    log.error("Error closing genome stream: " + genomeArchiveURL.toString(), e3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenomeDescriptor createGenomeDescriptor(File f2, boolean userDefined) throws IOException {
        String zipFilePath = f2.getAbsolutePath();
        if (!f2.exists()) {
            log.error("Genome file: " + f2.getAbsolutePath() + " does not exist.");
            return null;
        }
        GenomeZipDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(f2));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                if (zipEntryName.equalsIgnoreCase("property.txt")) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String cytobandZipEntryName = properties.getProperty("cytobandFile");
                    String geneFileName = properties.getProperty("geneFile");
                    String sequenceLocation = properties.getProperty("sequenceLocation");
                    if (sequenceLocation != null && !sequenceLocation.startsWith("http:") && !sequenceLocation.startsWith("https:")) {
                        File tempZipFile = new File(zipFilePath);
                        File sequenceFolder = new File(tempZipFile.getParent(), sequenceLocation);
                        sequenceLocation = sequenceFolder.getCanonicalPath();
                        sequenceLocation.replace('\\', '/');
                    }
                    int version = 0;
                    String versionString = properties.getProperty("version");
                    if (versionString != null) {
                        try {
                            version = Integer.parseInt(versionString);
                        }
                        catch (Exception e2) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chrNamesAltered = false;
                    String chrNamesAlteredString = properties.getProperty("filenamesAltered");
                    if (chrNamesAlteredString != null) {
                        try {
                            chrNamesAltered = Boolean.parseBoolean(chrNamesAlteredString);
                        }
                        catch (Exception e3) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chromosomesAreOrdered = false;
                    String tmp = properties.getProperty("ordered");
                    if (tmp != null) {
                        try {
                            chromosomesAreOrdered = Boolean.parseBoolean(tmp);
                        }
                        catch (Exception e4) {
                            log.error("Error parsing ordered string: " + tmp);
                        }
                    }
                    genomeDescriptor = new GenomeZipDescriptor(properties.getProperty("name"), version, chrNamesAltered, properties.getProperty("id"), cytobandZipEntryName, geneFileName, properties.getProperty("geneTrackName", "Gene"), sequenceLocation, zipFile, zipEntries, userDefined, chromosomesAreOrdered);
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    public GenomeDescriptor getGenomeDescriptor(String id) {
        if (this.genomeDescriptorMap.containsKey(id)) {
            return this.genomeDescriptorMap.get(id);
        }
        return this.getDefaultGenomeDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashSet<GenomeListItem> getServerGenomeArchiveList(Set excludedArchivesUrls) throws IOException {
        if (this.serverGenomeArchiveList == null) {
            if (this.serverGenomeListUnreachable) {
                return null;
            }
            this.serverGenomeArchiveList = new LinkedHashSet();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            HttpURLConnection conn = null;
            try {
                String genomeRecord;
                String genomeListURLString = PreferenceManager.getInstance().getGenomeListURL();
                URL serverGenomeURL = new URL(genomeListURLString);
                if (genomeListURLString.startsWith("ftp:")) {
                    MessageUtils.showMessage("FTP protocol not supported for genome URL");
                } else if (genomeListURLString.startsWith("http:") || genomeListURLString.startsWith("https:")) {
                    conn = IGVHttpUtils.openConnection(serverGenomeURL);
                    conn.setReadTimeout(10000);
                    conn.setConnectTimeout(10000);
                    inputStream = IGVHttpUtils.openConnectionStream(serverGenomeURL);
                    inputStream = IGVHttpUtils.openHttpStream(serverGenomeURL, conn);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? serverGenomeURL.getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                boolean wasHeaderRead = false;
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("(#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        if (excludedArchivesUrls != null && excludedArchivesUrls.contains(fields[1])) continue;
                        int version = 0;
                        if (fields.length > 3) {
                            try {
                                version = Integer.parseInt(fields[3]);
                            }
                            catch (Exception e2) {
                                log.error("Error parsing genome version: " + fields[0], e2);
                            }
                        }
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        boolean valid = true;
                        if (url.length() == 0) {
                            log.error("Genome entry : " + name + " has an empty URL string.  Check for extra tabs in the definition file: " + PreferenceManager.getInstance().getGenomeListURL());
                            valid = false;
                        }
                        if (!valid) continue;
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], fields[1], fields[2], version, false);
                            this.serverGenomeArchiveList.add(item);
                        }
                        catch (Exception e3) {
                            log.error("Error reading a line from server genome list line was: [" + genomeRecord + "]", e3);
                        }
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e4) {
                this.serverGenomeListUnreachable = true;
                log.error("Error fetching genome list: ", e4);
                ConfirmDialog.optionallyShowInfoDialog("Warning: There was an error connecting to the genome server (" + e4.toString() + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    dataReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.serverGenomeArchiveList;
    }

    public LinkedHashSet<GenomeListItem> getUserDefinedGenomeArchiveList() throws IOException {
        if (this.userDefinedGenomeArchiveList == null) {
            this.userDefinedGenomeArchiveList = new LinkedHashSet();
            File listFile = new File(this.GENOME_CACHE_DIRECTORY, USER_DEFINED_GENOME_LIST_FILE);
            boolean clientGenomeListNeedsRebuilding = false;
            Properties listProperties = GenomeManager.retrieveUserDefinedGenomeListFromFile(listFile);
            if (listProperties != null) {
                Collection<Object> records = listProperties.values();
                for (Object value : records) {
                    String[] fields;
                    File file;
                    String record = (String)value;
                    if (record.trim().equals("") || (file = new File((fields = record.split("\t"))[1])).isDirectory()) continue;
                    if (!file.exists()) {
                        clientGenomeListNeedsRebuilding = true;
                        continue;
                    }
                    if (!file.getName().toLowerCase().endsWith(".genome")) continue;
                    GenomeListItem item = new GenomeListItem(fields[0], file.getAbsolutePath(), fields[2], 0, true);
                    this.userDefinedGenomeArchiveList.add(item);
                }
            }
            if (clientGenomeListNeedsRebuilding) {
                this.rebuildClientGenomeList(this.userDefinedGenomeArchiveList);
            }
        }
        return this.userDefinedGenomeArchiveList;
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = this.GENOME_CACHE_DIRECTORY.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashSet<GenomeListItem> getCachedGenomeArchiveList() throws IOException {
        if (this.cachedGenomeArchiveList == null) {
            File[] files;
            this.cachedGenomeArchiveList = new LinkedHashSet();
            if (!this.GENOME_CACHE_DIRECTORY.exists()) {
                return this.cachedGenomeArchiveList;
            }
            for (File file : files = this.GENOME_CACHE_DIRECTORY.listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                URL zipUrl = file.toURI().toURL();
                ZipFile zipFile = null;
                FileInputStream fis = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipFile = new ZipFile(file);
                    fis = new FileInputStream(file);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    int version = 0;
                    if (properties.containsKey("version")) {
                        try {
                            version = Integer.parseInt(properties.getProperty("version"));
                        }
                        catch (Exception e2) {
                            log.error("Error parsing genome version: " + version, e2);
                        }
                    }
                    GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"), version, false);
                    this.cachedGenomeArchiveList.add(item);
                }
                catch (ZipException ex) {
                    log.error("\nZip error unzipping cached genome.", ex);
                    try {
                        file.delete();
                        zipInputStream.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                catch (IOException ex) {
                    log.warn("\nIO error unzipping cached genome.", ex);
                    try {
                        file.delete();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error closing genome zip stream!", ex);
                    }
                }
            }
        }
        return this.cachedGenomeArchiveList;
    }

    public LinkedHashSet<GenomeListItem> getAllGenomeArchives() throws IOException {
        LinkedHashSet<GenomeListItem> genomeListItems = new LinkedHashSet<GenomeListItem>();
        LinkedHashSet<GenomeListItem> serverSideItemList = null;
        try {
            serverSideItemList = this.getServerGenomeArchiveList(null);
        }
        catch (UnknownHostException e2) {
            log.error("The Genome server is currently inaccessible.", e2);
        }
        catch (SocketException e3) {
            log.error("The Genome server is currently inaccessible.", e3);
        }
        LinkedHashSet<GenomeListItem> cacheGenomeItemList = this.getCachedGenomeArchiveList();
        LinkedHashSet<GenomeListItem> userDefinedItemList = this.getUserDefinedGenomeArchiveList();
        if (serverSideItemList != null) {
            genomeListItems.addAll(serverSideItemList);
        }
        if (userDefinedItemList != null) {
            genomeListItems.addAll(userDefinedItemList);
        }
        if (cacheGenomeItemList != null) {
            genomeListItems.addAll(cacheGenomeItemList);
        }
        if (genomeListItems.isEmpty()) {
            GenomeDescriptor defaultDes = this.getDefaultGenomeDescriptor();
            GenomeListItem defaultItem = new GenomeListItem(defaultDes.getName(), null, defaultDes.getId(), 0, false);
            genomeListItems.add(defaultItem);
            Genome genome = this.loadGenome(defaultDes);
            this.genomes.put(defaultDes.getId(), genome);
        }
        return genomeListItems;
    }

    public void rebuildClientGenomeList(LinkedHashSet<GenomeListItem> genomeItemList) throws IOException {
        if (genomeItemList == null) {
            return;
        }
        File listFile = new File(this.GENOME_CACHE_DIRECTORY, USER_DEFINED_GENOME_LIST_FILE);
        if (!listFile.exists()) {
            listFile.createNewFile();
        }
        StringBuffer buffer = new StringBuffer();
        Properties listProperties = new Properties();
        for (GenomeListItem genomeListItem : genomeItemList) {
            buffer.append(genomeListItem.getDisplayableName());
            buffer.append("\t");
            buffer.append(genomeListItem.getLocation());
            buffer.append("\t");
            buffer.append(genomeListItem.getId());
            listProperties.setProperty(genomeListItem.getId(), buffer.toString());
            buffer.delete(0, buffer.length());
        }
        GenomeImporter.storeUserDefinedGenomeListToFile(listFile, listProperties);
    }

    public String buildClientSideGenomeListRecord(File genomeArchive, boolean userDefined) throws IOException {
        GenomeDescriptor genomeDescriptor = this.createGenomeDescriptor(genomeArchive, userDefined);
        StringBuffer buffer = new StringBuffer();
        buffer.append(genomeDescriptor.getName());
        buffer.append("\t");
        buffer.append(genomeArchive.getAbsoluteFile());
        buffer.append("\t");
        buffer.append(genomeDescriptor.getId());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties retrieveUserDefinedGenomeListFromFile(File file) {
        Properties properties = new Properties();
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                properties.load(input);
            }
            catch (FileNotFoundException e2) {
                log.error("Property file for user-defined genomes was not found!", e2);
            }
            catch (IOException e3) {
                log.error("Error readin property file for user-defined genomes!", e3);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e4) {
                        log.error("Error closing property file for user-defined genomes!", e4);
                    }
                }
            }
        }
        return properties;
    }

    public GenomeListItem defineGenome(String genomeZipLocation, String cytobandFileName, String refFlatFileName, String fastaFileName, String relativeSequenceLocation, String genomeDisplayName, String genomeId, String genomeFileName, ProgressMonitor monitor, String sequenceOutputLocationOverride) throws IOException {
        File zipFileLocation = null;
        File fastaInputFile = null;
        File refFlatFile = null;
        File cytobandFile = null;
        if (genomeZipLocation != null && genomeZipLocation.trim().length() != 0) {
            zipFileLocation = new File(genomeZipLocation);
            PreferenceManager.getInstance().setLastGenomeImportDirectory(zipFileLocation);
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
            PreferenceManager.getInstance().setLastCytobandDirectory(cytobandFile.getParentFile());
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
            PreferenceManager.getInstance().setLastRefFlatDirectory(refFlatFile.getParentFile());
        }
        if (fastaFileName != null && fastaFileName.trim().length() != 0) {
            fastaInputFile = new File(fastaFileName);
            PreferenceManager.getInstance().setLastFastaDirectory(fastaInputFile.getParentFile());
            if (relativeSequenceLocation != null && relativeSequenceLocation.trim().length() != 0) {
                File sequenceLocation = new File(genomeZipLocation, relativeSequenceLocation);
                if (!sequenceLocation.exists()) {
                    sequenceLocation.mkdir();
                }
                PreferenceManager.getInstance().setLastSequenceDirectory(sequenceLocation);
            }
        }
        if (monitor != null) {
            monitor.fireProgressChange(25);
        }
        File archiveFile = new GenomeImporter().createGenomeArchive(zipFileLocation, genomeFileName, genomeId, genomeDisplayName, relativeSequenceLocation, fastaInputFile, refFlatFile, cytobandFile, sequenceOutputLocationOverride, monitor);
        if (monitor != null) {
            monitor.fireProgressChange(75);
        }
        if (log.isDebugEnabled()) {
            log.debug("Call loadGenome");
        }
        return this.loadGenome(archiveFile.getAbsolutePath(), true, null);
    }

    public static String generateGenomeKeyFromText(String text) {
        if (text == null) {
            return null;
        }
        text = text.trim();
        text = text.replace(" ", "_");
        text = text.replace("(", "");
        text = text.replace(")", "");
        text = text.replace("[", "");
        text = text.replace("]", "");
        text = text.replace("{", "");
        text = text.replace("}", "");
        return text;
    }

    public GenomeListItem getTopGenomeListItem() {
        try {
            LinkedHashSet<GenomeListItem> allItems = this.getAllGenomeArchives();
            if (allItems.size() > 0) {
                return (GenomeListItem)allItems.iterator().next();
            }
        }
        catch (IOException e2) {
            log.error("Error loading genome list: ", e2);
        }
        return this.getDefaultGenomeListItem();
    }

    public GenomeListItem getDefaultGenomeListItem() {
        GenomeDescriptor desc = this.getDefaultGenomeDescriptor();
        return new GenomeListItem(desc.getName(), null, desc.getId(), 0, false);
    }

    private GenomeDescriptor getDefaultGenomeDescriptor() {
        if (DEFAULT_GENOME == null) {
            DEFAULT_GENOME = new GenomeResourceDescriptor("Human hg18", 0, "hg18", "/resources/hg18_cytoBand.txt", null, null, "http://www.broadinstitute.org/igv/sequence/hg18", false);
        }
        return DEFAULT_GENOME;
    }

    public synchronized Map<String, String> getGenomeAliasTable() {
        if (this.aliasTable == null) {
            this.aliasTable = new HashMap<String, String>();
            try {
                URL url = new URL(ALIAS_URL);
                InputStream is = IGVHttpUtils.openConnectionStream(url);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String nextLine = "";
                while ((nextLine = br.readLine()) != null) {
                    String[] kv = nextLine.split("\t");
                    if (kv.length <= 1) continue;
                    this.aliasTable.put(kv[0], kv[1]);
                }
                is.close();
            }
            catch (IOException e2) {
                log.error("Error fetching genome alias table from: http://www.broadinstitute.org/igvdata/genomes/alias.txt", e2);
            }
        }
        return this.aliasTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getChromosomeAliasTable(String genomeId) {
        File aliasFile = new File(this.GENOME_CACHE_DIRECTORY, genomeId + "_alias.tab");
        log.debug("Looking for chromosome alias file: " + aliasFile.getAbsolutePath());
        if (aliasFile.exists()) {
            log.debug("Loading chromosome alias table ");
            BufferedReader br = null;
            HashMap<String, String> chrAliasTable = new HashMap<String, String>();
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                String nextLine = "";
                while ((nextLine = br.readLine()) != null) {
                    String[] kv = nextLine.split("\t");
                    if (kv.length <= 1) continue;
                    log.debug(kv[0] + " -> " + kv[1]);
                    chrAliasTable.put(kv[0], kv[1]);
                }
                HashMap<String, String> hashMap = chrAliasTable;
                return hashMap;
            }
            catch (IOException e2) {
                log.error("Error loading chr alias table", e2);
                MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e2.toString());
                Map<String, String> map = null;
                return map;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static class GenomeListItem {
        private int version;
        private String displayableName;
        private String location;
        private String id;
        private boolean isUserDefined = false;

        public GenomeListItem(String displayableName, String url, String id, int version, boolean isUserDefined) {
            this.displayableName = displayableName;
            this.location = url;
            this.id = id;
            this.version = version;
            this.isUserDefined = isUserDefined;
        }

        public String getDisplayableName() {
            return this.displayableName;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isUserDefined() {
            return this.isUserDefined;
        }

        public String toString() {
            return this.getDisplayableName();
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.displayableName == null ? 0 : this.displayableName.trim().hashCode());
            hash = hash * 13 + (this.id == null ? 0 : this.id.trim().hashCode());
            return hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GenomeListItem)) {
                return false;
            }
            GenomeListItem item = (GenomeListItem)object;
            return this.getId().equals(item.getId());
        }
    }
}

