/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDB {
    private static Logger log = Logger.getLogger(FeatureDB.class);
    private static Map<String, Feature> featureMap = new HashMap<String, Feature>(10000);

    public static void addFeature(Feature feature) {
        if (Globals.isHeadless()) {
            return;
        }
        Genome currentGenome = ViewContext.getInstance().getGenome();
        if (currentGenome == null) {
            return;
        }
        if (currentGenome.getChromosome(feature.getChr()) != null) {
            if (feature.getName() != null && feature.getName().length() > 0) {
                featureMap.put(feature.getName().trim().toUpperCase(), feature);
            }
            if (feature.getIdentifier() != null && feature.getIdentifier().length() > 0) {
                featureMap.put(feature.getIdentifier().trim().toUpperCase(), feature);
            }
        }
    }

    private FeatureDB() {
    }

    public static void addFeatures(List<Feature> features) {
        for (Feature feature : features) {
            FeatureDB.addFeature(feature);
        }
    }

    public static void clearFeatures() {
        featureMap.clear();
    }

    public static Feature getFeature(String nm) {
        String name = nm.trim().toUpperCase();
        String currentGenome = ViewContext.getInstance().getGenomeId();
        GeneManager gm = GeneManager.getGeneManager(currentGenome);
        Feature gene = null;
        if (gm != null && (gene = gm.getGene(name)) != null) {
            return gene;
        }
        return featureMap.get(name);
    }
}

