/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.HashMap;
import java.util.HashSet;
import org.broad.igv.feature.GenomeManager;

public class CommandLineGenomeBuilder {
    private static final String GENOME_OUTPUT_LOCATION = "outputLocation";
    private static final String GENOME_DISPLAY_NAME = "genomeName";
    private static final String SEQUENCE_FILE = "sequenceFile";
    private static final String GENOME_ID = "genomeId";
    private static final String CYTOBAND_FILE = "cytobandFile";
    private static final String GENE_FILE = "geneFile";
    private static final String SEQUENCE_OUTPUT_LOCATION_OVERRIDE = "sequenceLocationOverride";
    private static final String GENOME_ARCHIVE_FILENAME_PREFIX_OVERRIDE = "archiveFilenamePrefix";
    static final HashSet<String> validCommandLineOptions = new HashSet();

    public static void main(String[] args) throws Exception {
        CommandLineGenomeBuilder.buildGenome(args);
    }

    public static GenomeManager.GenomeListItem buildGenome(String[] args) throws Exception {
        if (args.length == 0) {
            throw new RuntimeException("No command line parameters supplied!");
        }
        HashMap<String, String> commandLineValues = new HashMap<String, String>();
        for (String parameter : args) {
            String[] optionAndValue = parameter.split("=");
            if (optionAndValue.length != 2) {
                throw new RuntimeException("Invalid command line option=value set:[" + parameter + "]");
            }
            if (!validCommandLineOptions.contains(optionAndValue[0])) {
                throw new RuntimeException("Invalid command line option:[" + optionAndValue[0] + "]");
            }
            commandLineValues.put(optionAndValue[0], optionAndValue[1]);
        }
        if (!commandLineValues.containsKey(GENOME_OUTPUT_LOCATION)) {
            throw new RuntimeException("No genome output location was supplied!");
        }
        if (!commandLineValues.containsKey(GENOME_DISPLAY_NAME)) {
            throw new RuntimeException("No Genome name was supplied!");
        }
        if (!commandLineValues.containsKey(SEQUENCE_FILE)) {
            throw new RuntimeException("No Sequence file was supplied!");
        }
        String genomeZipOutputLocation = (String)commandLineValues.get(GENOME_OUTPUT_LOCATION);
        String genomeDisplayName = (String)commandLineValues.get(GENOME_DISPLAY_NAME);
        String fastaFileName = (String)commandLineValues.get(SEQUENCE_FILE);
        String genomeId = (String)commandLineValues.get(GENOME_ID);
        String sequenceOutputLocationOverride = (String)commandLineValues.get(SEQUENCE_OUTPUT_LOCATION_OVERRIDE);
        String cytobandFileName = (String)commandLineValues.get(CYTOBAND_FILE);
        String refFlatFileName = (String)commandLineValues.get(GENE_FILE);
        String genomeArchiveFilenamePrefix = (String)commandLineValues.get(GENOME_ARCHIVE_FILENAME_PREFIX_OVERRIDE);
        genomeDisplayName = genomeDisplayName.trim();
        if ((genomeId = genomeId.trim()) == null || genomeId.length() == 0) {
            GenomeManager.getInstance();
            genomeId = GenomeManager.generateGenomeKeyFromText(genomeDisplayName);
        }
        String genomeFileName = null;
        genomeFileName = genomeArchiveFilenamePrefix != null ? genomeArchiveFilenamePrefix + ".genome" : genomeId + ".genome";
        String relativeSequenceLocation = null;
        if (fastaFileName != null && !fastaFileName.trim().equals("")) {
            relativeSequenceLocation = genomeArchiveFilenamePrefix != null ? "/" + genomeArchiveFilenamePrefix + "_seq/" : "/" + genomeId + "_seq/";
        }
        GenomeManager.GenomeListItem item = GenomeManager.getInstance().defineGenome(genomeZipOutputLocation, cytobandFileName, refFlatFileName, fastaFileName, relativeSequenceLocation, genomeDisplayName, genomeId, genomeFileName, null, sequenceOutputLocationOverride);
        return item;
    }

    static {
        validCommandLineOptions.add(GENOME_OUTPUT_LOCATION);
        validCommandLineOptions.add(GENOME_DISPLAY_NAME);
        validCommandLineOptions.add(SEQUENCE_FILE);
        validCommandLineOptions.add(CYTOBAND_FILE);
        validCommandLineOptions.add(GENE_FILE);
        validCommandLineOptions.add(SEQUENCE_OUTPUT_LOCATION_OVERRIDE);
        validCommandLineOptions.add(GENOME_ARCHIVE_FILENAME_PREFIX_OVERRIDE);
    }
}

