/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.EmblFeatureTableParser;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.PSLParser;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.UCSCGeneTableParser;
import org.broad.igv.renderer.BasicFeatureRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureParser
implements FeatureParser {
    private static Logger log = Logger.getLogger(IGVMainFrame.class);
    private String filePath;
    protected Genome genome = ViewContext.getInstance().getGenome();
    protected int startBase = 0;
    private TrackProperties trackProperties = null;
    TrackType trackType;

    public static FeatureParser getInstanceFor(ResourceLocator locator) {
        String tmp = AbstractFeatureParser.getStrippedFilename(locator.getPath());
        if (tmp.endsWith("bed") || tmp.endsWith("map")) {
            return new BEDFileParser();
        }
        if (tmp.endsWith("psl")) {
            return new PSLParser();
        }
        if (tmp.contains("refflat")) {
            return new UCSCGeneTableParser(UCSCGeneTableParser.Type.REFFLAT);
        }
        if (tmp.contains("genepred") || tmp.contains("ensgene") || tmp.contains("refgene")) {
            return new UCSCGeneTableParser(UCSCGeneTableParser.Type.GENEPRED);
        }
        if (tmp.contains("ucscgene")) {
            return new UCSCGeneTableParser(UCSCGeneTableParser.Type.UCSCGENE);
        }
        if (tmp.endsWith("gtf") || tmp.endsWith("gff") || tmp.endsWith("gff3")) {
            return new GFFParser(locator.getPath());
        }
        if (tmp.endsWith("embl")) {
            return new EmblFeatureTableParser();
        }
        return null;
    }

    @Override
    public boolean isFeatureFile(ResourceLocator locator) {
        return true;
    }

    @Override
    public List<FeatureTrack> loadTracks(ResourceLocator locator) {
        List<Feature> features = this.loadFeatures(locator, -1);
        if (features.size() == 0) {
            throw new DataLoadException("No features were found in this file with chromosomes mapped to the current genome", locator.getPath());
        }
        FeatureCollectionSource source = new FeatureCollectionSource(features);
        FeatureTrack track = new FeatureTrack(locator, (FeatureSource)source);
        track.setName(locator.getTrackName());
        track.setRendererClass(BasicFeatureRenderer.class);
        track.setMinimumHeight(35);
        track.setHeight(45);
        if (this.trackType != null) {
            track.setTrackType(this.trackType);
        }
        if (this.trackProperties != null) {
            track.setTrackProperties(this.trackProperties);
        }
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        tracks.add(track);
        return tracks;
    }

    protected List<Feature> loadFeatures(ResourceLocator locator, int maxLines) {
        boolean nLines = false;
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            List<Feature> list = this.loadFeatures(reader, maxLines);
            return list;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public List<Feature> loadFeatures(AsciiLineReader reader) {
        return this.loadFeatures(reader, -1);
    }

    public List<Feature> loadFeatures(AsciiLineReader reader, int maxLines) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String nextLine = null;
        try {
            int nLines = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                nextLine = nextLine.trim();
                if (maxLines <= 0 || ++nLines <= maxLines) {
                    try {
                        if (nextLine.startsWith("#")) {
                            String[] tokens;
                            if (nextLine.startsWith("#type")) {
                                tokens = nextLine.split("=");
                                if (tokens.length <= 1) continue;
                                try {
                                    TrackType type = TrackType.valueOf(tokens[1]);
                                }
                                catch (Exception e2) {
                                    log.error("Error converting track type: " + tokens[1]);
                                }
                                continue;
                            }
                            if (nextLine.startsWith("#track")) {
                                TrackProperties tp = new TrackProperties();
                                ParsingUtils.parseTrackLine(nextLine, tp);
                                this.setTrackProperties(tp);
                                continue;
                            }
                            if (!nextLine.startsWith("#coords")) continue;
                            try {
                                tokens = nextLine.split("=");
                                this.startBase = Integer.parseInt(tokens[1]);
                            }
                            catch (Exception e3) {
                                log.error("Error parsing coords line: " + nextLine, e3);
                            }
                            continue;
                        }
                        Feature feature = this.parseLine(nextLine);
                        if (feature == null) continue;
                        features.add(feature);
                    }
                    catch (NumberFormatException e4) {}
                    continue;
                }
                break;
            }
        }
        catch (EOFException e5) {
            return features;
        }
        catch (Exception e6) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e6.getMessage(), (Throwable)e6, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e6);
        }
        this.parsingComplete(features);
        FeatureDB.addFeatures(features);
        return features;
    }

    protected void parsingComplete(List<Feature> features) {
    }

    protected abstract Feature parseLine(String var1);

    protected static String getStrippedFilename(String filename) {
        String tmp = filename.toLowerCase();
        if (filename.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        if (tmp.endsWith(".tab") || tmp.endsWith(".txt") || tmp.endsWith(".csv")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFeatures(List<Feature> features, String outputfile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputfile));
            pw.println("Header row");
            for (Feature gene : features) {
                pw.print(gene.getName() + "\t");
                pw.print(gene.getIdentifier() + "\t");
                pw.print(gene.getChr() + "\t");
                if (gene.getStrand() == Strand.POSITIVE) {
                    pw.print("+\t");
                } else if (gene.getStrand() == Strand.NEGATIVE) {
                    pw.print("-\t");
                } else {
                    pw.print(" \t");
                }
                pw.print(gene.getStart() + "\t");
                pw.print(gene.getEnd() + "\t");
                List<Exon> regions = gene.getExons();
                pw.print(regions.size() + "\t");
                for (Exon exon : regions) {
                    pw.print(exon.getStart() + ",");
                }
                pw.print("\t");
                for (Exon exon : regions) {
                    pw.print(exon.getEnd() + ",");
                }
                pw.println();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    protected void setTrackProperties(TrackProperties trackProperties) {
        this.trackProperties = trackProperties;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }
}

