/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentedDataSource
implements DataSource {
    String trackIdentifier;
    SegmentedDataSet dataset;

    public SegmentedDataSource(String trackIdentifier, SegmentedDataSet dataset) {
        this.trackIdentifier = trackIdentifier;
        this.dataset = dataset;
    }

    @Override
    public void refreshData(long timestamp) {
        this.dataset.refreshData(timestamp);
    }

    @Override
    public TrackType getTrackType() {
        return this.dataset.getType();
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataset.isLogNormalized();
    }

    @Override
    public double getDataMax() {
        return this.dataset.getDataMax("All");
    }

    @Override
    public double getDataMin() {
        return this.dataset.getDataMin("All");
    }

    public double getMedian(int zoom, String chr) {
        return 1.0;
    }

    private List<LocusScore> getSegments(String chr) {
        return this.dataset.getSegments(this.trackIdentifier, chr);
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        if (chr.equals("All")) {
            return this.getWholeGenomeScores();
        }
        return this.getSegments(chr);
    }

    public List<LocusScore> getWholeGenomeScores() {
        return this.dataset.getWholeGenomeScores(this.trackIdentifier);
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }
}

