/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.data.rnai.RNAIDataSource;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.GeneManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAIGeneScoreParser {
    private static Logger log = Logger.getLogger(RNAIGeneScoreParser.class);
    private String filename;
    private String genomeId;
    private int maxColumn = -1;
    private int batchColumn = -1;
    private int conditionColumn = -1;
    private int geneColumn = -1;
    private int hairpinColumn = -1;
    private int scoreColumn = -1;
    private int confidenceColumn = -1;

    public RNAIGeneScoreParser(String filename, String genomeId, Type type) {
        this.genomeId = genomeId;
        this.filename = filename;
        if (type == Type.GENE_SCORE) {
            this.batchColumn = 0;
            this.conditionColumn = 2;
            this.geneColumn = 5;
            this.hairpinColumn = 12;
            this.scoreColumn = 8;
            this.confidenceColumn = 9;
            this.maxColumn = 12;
        } else {
            this.batchColumn = -1;
            this.conditionColumn = -1;
            this.geneColumn = 0;
            this.hairpinColumn = 1;
            this.scoreColumn = 3;
            this.confidenceColumn = 2;
            this.maxColumn = 3;
        }
    }

    public Collection<RNAIDataSource> parse() {
        BufferedReader reader = null;
        try {
            log.debug("Loading data for: " + this.filename);
            reader = new BufferedReader(new FileReader(this.filename));
            this.parseAttributes(reader);
            this.parseHeaderRow(reader);
            GeneManager gm = GeneManager.getGeneManager(this.genomeId);
            String nextLine = reader.readLine();
            while ((nextLine = reader.readLine()) != null && (nextLine.startsWith("#") || nextLine.length() == 0)) {
            }
            HashMap<String, RNAIDataSource> dataSources = new HashMap<String, RNAIDataSource>();
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                if (tokens.length <= this.maxColumn) continue;
                try {
                    String batchId = this.batchColumn < 0 ? "" : tokens[this.batchColumn].trim();
                    String geneName = tokens[this.geneColumn].trim().toUpperCase();
                    Feature gene = FeatureDB.getFeature(geneName);
                    if (gene != null) {
                        String batchCond;
                        RNAIDataSource ds;
                        String cond;
                        float geneScore = Float.NaN;
                        try {
                            geneScore = Float.parseFloat(tokens[this.scoreColumn]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int confidence = 0;
                        try {
                            confidence = Integer.parseInt(tokens[this.confidenceColumn]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int numberOfHairpins = 0;
                        try {
                            numberOfHairpins = Integer.parseInt(tokens[this.hairpinColumn]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if ((cond = this.conditionColumn < 0 ? "" : tokens[this.conditionColumn].trim()).startsWith("*")) continue;
                        if (cond.equals("None") || cond.equals("Standard")) {
                            cond = "";
                        }
                        if ((ds = (RNAIDataSource)dataSources.get(batchCond = batchId + "_" + cond)) == null) {
                            ds = new RNAIDataSource(batchId, cond);
                            dataSources.put(batchCond, ds);
                        }
                        ds.addGeneScore(new RNAIGeneScore(batchCond, gene, geneScore, confidence, numberOfHairpins));
                        continue;
                    }
                    log.info("Unknown gene: " + geneName);
                }
                catch (Exception ex) {
                    log.error("Skipping line: " + nextLine, ex);
                }
            }
            Collection<RNAIDataSource> collection = dataSources.values();
            return collection;
        }
        catch (FileNotFoundException e2) {
            log.error("RNAI file not found: " + this.filename);
            throw new RuntimeException("File not found");
        }
        catch (IOException e3) {
            log.error(this.filename, e3);
            throw new RuntimeException("Error parsing file.", e3);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseAttributes(BufferedReader reader) throws IOException {
    }

    private void parseHeaderRow(BufferedReader reader) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        GENE_SCORE,
        POOLED;

    }
}

