/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.GCTDataConsumer;
import org.broad.igv.data.GCTDataset;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.exceptions.ProbeMappingException;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.IntArrayList;

public class GCTDatasetParser {
    private static Logger log = Logger.getLogger(GCTDatasetParser.class);
    static String LOCUS_START_DELIMITER = "|@";
    static String LOCUS_END_DELIMITER = "|";
    ResourceLocator dataFileLocator;
    Map<String, Feature> probeLocusMap;
    FileType type;
    int dataStartColumn;
    int probeColumn;
    int descriptionColumn;
    String genome;
    Map<String, Integer> longestProbeMap;
    private Map<String, Integer> headingIndexMap = new HashMap<String, Integer>();
    Map<String, List<Row>> rowMap = new HashMap<String, List<Row>>();
    StatusMonitor statusMonitor;
    GeneManager geneManager = null;

    public GCTDatasetParser(ResourceLocator resFile, String probeFile, String genome) throws IOException {
        this.dataFileLocator = resFile;
        this.genome = genome;
        this.geneManager = GeneManager.getGeneManager(genome);
        this.longestProbeMap = new HashMap<String, Integer>();
        if (probeFile != null) {
            BEDFileParser parser = new BEDFileParser();
            ResourceLocator rl = new ResourceLocator(probeFile);
            AsciiLineReader reader = ParsingUtils.openAsciiReader(rl);
            List<Feature> features = parser.loadFeatures(reader);
            reader.close();
            this.probeLocusMap = new HashMap<String, Feature>(features.size() * 2);
            for (Feature f2 : features) {
                this.probeLocusMap.put(f2.getName(), f2);
            }
        }
    }

    public GCTDatasetParser(File resFile, String probeFile, String genome) throws IOException {
        this(new ResourceLocator(resFile.getAbsolutePath()), probeFile, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsableMAGE_TAB(ResourceLocator file) throws IOException {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            reader.readLine();
            nextLine = reader.readLine();
            if (nextLine != null && (nextLine.contains("Reporter REF") || nextLine.contains("Composite Element REF") || nextLine.contains("Term Source REF") || nextLine.contains("CompositeElement REF") || nextLine.contains("TermSource REF") || nextLine.contains("Coordinates REF"))) {
                for (int count = 0; (nextLine = reader.readLine()) != null && count < 5; ++count) {
                    if (!(nextLine = nextLine.trim()).startsWith("SNP_A") && !nextLine.startsWith("CN_")) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return false;
    }

    public GCTDataset createDataset() {
        GCTDataset dataset = new GCTDataset(this.genome);
        this.parse(dataset);
        return dataset;
    }

    public void parse(GCTDataset dataset) {
        String[] tokens = new String[100000];
        String fn = this.dataFileLocator.getPath().toLowerCase();
        if (fn.endsWith(".txt") || fn.endsWith(".tab") || fn.endsWith(".xls") || fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.lastIndexOf("."));
        }
        this.descriptionColumn = -1;
        if (fn.endsWith("res")) {
            this.type = FileType.RES;
            this.dataStartColumn = 2;
            this.probeColumn = 1;
            this.descriptionColumn = 0;
        } else if (fn.endsWith("gct")) {
            this.type = FileType.GCT;
            this.dataStartColumn = 2;
            this.probeColumn = 0;
            this.descriptionColumn = 1;
        } else if (fn.endsWith("mapped")) {
            this.type = FileType.MAPPED;
            this.dataStartColumn = 4;
            this.probeColumn = 0;
        } else if (fn.endsWith("met")) {
            this.type = FileType.MET;
            this.dataStartColumn = 4;
            this.probeColumn = 0;
        } else if (fn.endsWith("dchip")) {
            this.type = FileType.DCHIP;
            this.dataStartColumn = 1;
            this.probeColumn = 0;
            this.descriptionColumn = -1;
        } else if (this.dataFileLocator.getDescription() != null && this.dataFileLocator.getDescription().equals("MAGE_TAB")) {
            this.type = FileType.MAGE_TAB;
            this.descriptionColumn = -1;
            this.dataStartColumn = 1;
            this.probeColumn = 0;
        } else {
            this.type = FileType.TAB;
            this.dataStartColumn = 1;
            this.probeColumn = 0;
        }
        boolean hasCalls = this.type == FileType.RES;
        boolean hasDescription = this.descriptionColumn >= 0;
        dataset.setType(TrackType.GENE_EXPRESSION);
        AsciiLineReader reader = null;
        String nextLine = null;
        String[] columnHeadings = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.dataFileLocator);
            String headerLine = null;
            if (this.type == FileType.GCT) {
                nextLine = reader.readLine();
                if (nextLine.startsWith("#")) {
                    this.parseComment(nextLine, dataset);
                }
                if ((nextLine = reader.readLine()).startsWith("#")) {
                    this.parseComment(nextLine, dataset);
                }
                headerLine = reader.readLine();
            } else if (this.type != FileType.MAGE_TAB) {
                while ((nextLine = reader.readLine()).startsWith("#") && nextLine != null) {
                    this.parseComment(nextLine, dataset);
                }
                headerLine = nextLine;
            } else {
                headerLine = reader.readLine();
            }
            int skip = hasCalls ? 2 : 1;
            int nTokens = ParsingUtils.split(headerLine, tokens, '\t');
            int nColumns = (nTokens - this.dataStartColumn) / skip;
            ArrayList<String> columnHeadingsObj = new ArrayList<String>();
            for (int i2 = 0; i2 < nColumns; ++i2) {
                String heading = tokens[this.dataStartColumn + i2 * skip].replace('\"', ' ').trim();
                if (this.type == FileType.MAGE_TAB) {
                    if (columnHeadingsObj.contains(heading)) continue;
                    columnHeadingsObj.add(heading);
                    this.headingIndexMap.put(heading, columnHeadingsObj.size() - 1);
                    continue;
                }
                columnHeadingsObj.add(heading);
                this.headingIndexMap.put(heading, i2);
            }
            columnHeadings = columnHeadingsObj.toArray(new String[0]);
            dataset.setColumnHeadings(columnHeadings);
            nColumns = columnHeadings.length;
            IntArrayList valuesIndices = new IntArrayList(nColumns);
            if (this.type == FileType.MAGE_TAB) {
                nextLine = reader.readLine();
                nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                for (int i3 = this.dataStartColumn; i3 < nTokens; ++i3) {
                    String heading = tokens[i3].replace('\"', ' ').trim();
                    if (heading.contains("Beta value") || heading.contains("log2 Signal") || heading.contains("Signal") || heading.contains("unc_DWD_Batch_adjusted")) {
                        valuesIndices.add(i3);
                    }
                    if (!heading.contains("Gene symbol")) continue;
                    this.descriptionColumn = i3;
                    hasDescription = true;
                }
                if (nColumns != valuesIndices.size()) {
                    // empty if block
                }
            }
            if (this.type == FileType.RES) {
                reader.readLine();
                reader.readLine();
            }
            int lineCount = 0;
            while ((nextLine = reader.readLine()) != null) {
                String description;
                nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                String probeId = new String(tokens[this.probeColumn]);
                float[] values = new float[nColumns];
                char[] calls = hasCalls ? new char[nColumns] : (char[])null;
                String string = description = hasDescription && nTokens > this.descriptionColumn ? new String(tokens[this.descriptionColumn]) : null;
                if (this.type == FileType.MAGE_TAB && probeId.startsWith("cg")) {
                    dataset.setType(TrackType.DNA_METHYLATION);
                }
                for (int i4 = 0; i4 < nColumns; ++i4) {
                    try {
                        int dataIndex = -1;
                        if (this.type == FileType.MAGE_TAB) {
                            dataIndex = valuesIndices.get(i4);
                            if (hasDescription) {
                                description = "|@" + description + "|";
                            }
                        } else {
                            dataIndex = this.dataStartColumn + i4 * skip;
                        }
                        values[i4] = dataIndex >= nTokens || tokens[dataIndex].length() == 0 ? Float.NaN : Float.parseFloat(tokens[dataIndex]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[i4] = Float.NaN;
                    }
                    if (!hasCalls) continue;
                    calls[i4] = tokens[3 + i4 * skip].charAt(0);
                }
                this.addRow(probeId, description, values, calls);
                if (++lineCount != 1000) continue;
                this.checkForInterrupt();
                lineCount = 0;
                if (this.statusMonitor == null) continue;
                this.statusMonitor.incrementPercentComplete(1.0);
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Operation cancelled");
        }
        catch (Exception e3) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e3.getMessage(), (Throwable)e3, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e3);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.sortRows();
        for (String chr : this.rowMap.keySet()) {
            dataset.setStartLocations(chr, this.getStartLocations(chr));
            dataset.setEndLocations(chr, this.getEndLocations(chr));
            dataset.setFeatureNames(chr, this.getProbes(chr));
            for (String heading : columnHeadings) {
                dataset.setData(heading, chr, this.getData(heading, chr));
            }
        }
        dataset.setLongestFeatureMap(this.longestProbeMap);
        if (dataset == null || dataset.isEmpty()) {
            String genome = ViewContext.getInstance().getGenome().getId();
            throw new ProbeMappingException(fn, genome);
        }
    }

    public void addRow(String probeId, String description, float[] values, char[] calls) {
        Locus locus;
        String[] locusStrings;
        String chr = null;
        if (chr == null && description != null && description.length() > 3 && (locusStrings = this.getExplicitLocusStrings(description)) != null) {
            for (String ls : locusStrings) {
                Locus locus2 = this.getLocus(ls = ls.trim());
                if (locus2 == null || !locus2.isValid()) continue;
                chr = locus2.getChr();
                this.addRow(probeId, locus2, values);
            }
            return;
        }
        if (chr == null && (locus = this.getLocus(probeId)) != null && locus.isValid()) {
            this.addRow(probeId, locus, values);
            return;
        }
        String[] loci = ProbeToGeneMap.getInstance().getGenesForProbe(probeId);
        if (loci != null) {
            for (String locusString : loci) {
                Locus locus3 = this.getLocus(locusString);
                if (locus3 == null) continue;
                this.addRow(probeId, locus3, values);
            }
        }
    }

    private void addRow(String probeId, Locus locus, float[] values) {
        List<Row> rows = this.rowMap.get(locus.getChr());
        if (rows == null) {
            rows = new ArrayList<Row>();
            this.rowMap.put(locus.getChr(), rows);
        }
        String chr = locus.getChr();
        int length = locus.getEnd() - locus.getStart();
        if (this.longestProbeMap.containsKey(chr)) {
            this.longestProbeMap.put(chr, Math.max(this.longestProbeMap.get(chr), length));
        } else {
            this.longestProbeMap.put(chr, length);
        }
        rows.add(new Row(probeId, locus.getChr(), locus.getStart(), locus.getEnd(), values));
    }

    private void sortRows() {
        Comparator<Row> c2 = new Comparator<Row>(){

            @Override
            public int compare(Row arg0, Row arg1) {
                return arg0.start - arg1.start;
            }
        };
        for (List<Row> rows : this.rowMap.values()) {
            Collections.sort(rows, c2);
        }
    }

    public String[] getProbes(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        String[] labels = new String[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            labels[i2] = rows.get((int)i2).feature;
        }
        return labels;
    }

    public int[] getStartLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] startLocations = new int[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            startLocations[i2] = rows.get((int)i2).start;
        }
        return startLocations;
    }

    public int[] getEndLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] endLocations = new int[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            endLocations[i2] = rows.get((int)i2).end;
        }
        return endLocations;
    }

    public float[] getData(String heading, String chr) {
        int columnIndex = this.headingIndexMap.get(heading);
        List<Row> rows = this.rowMap.get(chr);
        float[] data = new float[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            data[i2] = rows.get((int)i2).values[columnIndex];
        }
        return data;
    }

    private String[] getExplicitLocusStrings(String description) {
        int startIndex = description.indexOf(LOCUS_START_DELIMITER);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = description.indexOf("|", (startIndex += 2) + 1);
        if (endIndex < 0) {
            endIndex = description.length();
        }
        if (endIndex > startIndex + 3) {
            String locusString = description.substring(startIndex, endIndex);
            if (locusString.contains(",")) {
                return locusString.split(",");
            }
            return new String[]{locusString};
        }
        return null;
    }

    Locus getLocus(String locusString) {
        Feature gene;
        Locus locus = new Locus(locusString);
        if (locus.isValid()) {
            return locus;
        }
        if (this.probeLocusMap != null) {
            Feature f2 = this.probeLocusMap.get(locusString);
            if (f2 == null) {
                return null;
            }
            return new Locus(f2.getChr(), f2.getStart(), f2.getEnd());
        }
        if (this.geneManager != null && (gene = FeatureDB.getFeature(locusString)) != null) {
            return new Locus(gene.getChr(), gene.getStart(), gene.getEnd());
        }
        return null;
    }

    private void parseComment(String comment, GCTDataConsumer dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            dataset.setTrackLine(tmp);
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        Thread.sleep(1L);
    }

    class Row {
        String feature;
        String chr;
        int start;
        int end;
        float[] values;

        Row(String feature, String chr, int start, int end, float[] values) {
            this.feature = feature;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.values = values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        RES,
        GCT,
        MAPPED,
        TAB,
        MET,
        DCHIP,
        MAGE_TAB;

    }
}

