/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.Map;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GCTDataConsumer;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCTDataset
implements Dataset,
GCTDataConsumer {
    private String name;
    private TrackType type = TrackType.GENE_EXPRESSION;
    private String genomeId;
    private Genome genome;
    private String[] columnHeadings;
    private boolean normalized = false;
    private boolean logValues = false;
    private Map<String, Integer> headingIndexMap = new HashMap<String, Integer>();
    Map<String, int[]> startLocationMap = new HashMap<String, int[]>();
    Map<String, int[]> endLocationMap = new HashMap<String, int[]>();
    private Map<String, Integer> longestFeatureMap;
    Map<String, Map<String, float[]>> dataMap = new HashMap<String, Map<String, float[]>>();
    Map<String, String[]> featureNameMap = new HashMap<String, String[]>();
    private TrackProperties trackProperties = new TrackProperties();

    public GCTDataset(String genomeId) {
        this.genomeId = genomeId;
        this.genome = GenomeManager.getInstance().getGenome(genomeId);
        if (this.genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
    }

    @Override
    public float getDataMin() {
        return -3.0f;
    }

    @Override
    public float getDataMax() {
        return 3.0f;
    }

    @Override
    public void setColumnHeadings(String[] columnHeadings) {
        this.columnHeadings = columnHeadings;
        for (int i2 = 0; i2 < columnHeadings.length; ++i2) {
            this.headingIndexMap.put(columnHeadings[i2], i2);
        }
    }

    @Override
    public String[] getDataHeadings() {
        return this.columnHeadings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(TrackType type) {
        this.type = type;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.startLocationMap.isEmpty();
    }

    @Override
    public String getGenome() {
        return this.genomeId;
    }

    @Override
    public String[] getChromosomes() {
        return this.startLocationMap.keySet().toArray(new String[0]);
    }

    @Override
    public void setFeatureNames(String chr, String[] names) {
        this.featureNameMap.put(chr, names);
    }

    @Override
    public String[] getFeatureNames(String chr) {
        return this.featureNameMap.get(chr);
    }

    @Override
    public void setStartLocations(String chr, int[] startLocations) {
        this.startLocationMap.put(chr, startLocations);
    }

    @Override
    public int[] getStartLocations(String chr) {
        return this.startLocationMap.get(chr);
    }

    @Override
    public void setEndLocations(String chr, int[] endLocations) {
        this.endLocationMap.put(chr, endLocations);
    }

    @Override
    public int[] getEndLocations(String chr) {
        if (chr.equals("All")) {
            return null;
        }
        return this.endLocationMap.get(chr);
    }

    @Override
    public int getWindowSpan() {
        return -1;
    }

    @Override
    public boolean isLogNormalized() {
        return this.normalized;
    }

    @Override
    public void setData(String heading, String chr, float[] data) {
        Map<String, float[]> tmp = this.dataMap.get(heading);
        if (tmp == null) {
            tmp = new HashMap<String, float[]>();
            this.dataMap.put(heading, tmp);
        }
        tmp.put(chr, data);
    }

    @Override
    public float[] getData(String heading, String chr) {
        Map<String, float[]> tmp = this.dataMap.get(heading);
        if (tmp != null) {
            return tmp.get(chr);
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    @Override
    public void setLogValues(boolean logValues) {
        this.logValues = logValues;
    }

    @Override
    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    @Override
    public void setTrackLine(String trackLine) {
        ParsingUtils.parseTrackLine(trackLine, this.trackProperties);
    }

    @Override
    public Integer getLongestFeature(String chr) {
        return this.longestFeatureMap == null ? 1000 : (this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : 1);
    }

    public void setLongestFeatureMap(Map<String, Integer> longestFeatureMap) {
        this.longestFeatureMap = longestFeatureMap;
    }
}

