/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

public class SQTagUtil {
    private static final int COMPLEMENT_MASK = 3;
    private static final int QUALITY_MASK = 63;
    public static final byte MAX_QUALITY = 63;
    private static final int BASE_INDEX_SHIFT = 6;

    public static byte sqScaledProbabilityRatio(double secondBestLikelihood, double thirdBestLikelihood) {
        if (secondBestLikelihood >= 1.0 || thirdBestLikelihood <= 0.0 || thirdBestLikelihood > secondBestLikelihood) {
            throw new IllegalArgumentException("Likelihoods out of range.  second best: " + secondBestLikelihood + "; third best: " + thirdBestLikelihood);
        }
        return (byte)Math.min(Math.round(-10.0 * Math.log10(thirdBestLikelihood / secondBestLikelihood)), 63L);
    }

    public static byte baseAndProbDiffToSqValue(SQBase base, byte probRatio) {
        return SQTagUtil.baseAndProbDiffToSqValue(base.ordinal(), probRatio);
    }

    public static byte baseAndProbDiffToSqValue(int base, byte probRatio) {
        return (byte)(base << 6 | Math.min(probRatio, 63));
    }

    public static byte sqValueToProbRatio(byte sqValue) {
        return (byte)(sqValue & 0x3F);
    }

    public static SQBase sqValueToBase(byte sqValue) {
        return SQBase.values()[SQTagUtil.sqValueToBaseOrdinal(sqValue)];
    }

    public static int sqValueToBaseOrdinal(byte sqValue) {
        return (sqValue & 0xFF) >>> 6;
    }

    public static void reverseComplementSqArray(byte[] sqArray) {
        int lastIndex = sqArray.length - 1;
        int i2 = 0;
        for (int j2 = lastIndex; i2 < j2; ++i2, --j2) {
            byte tmp = SQTagUtil.complementSqValue(sqArray[i2]);
            sqArray[i2] = SQTagUtil.complementSqValue(sqArray[j2]);
            sqArray[j2] = tmp;
        }
        if (sqArray.length % 2 == 1) {
            sqArray[i2] = SQTagUtil.complementSqValue(sqArray[i2]);
        }
    }

    private static byte complementSqValue(byte sqValue) {
        byte probDiff = SQTagUtil.sqValueToProbRatio(sqValue);
        int baseOrdinal = SQTagUtil.sqValueToBaseOrdinal(sqValue);
        int complementOrdinal = 3 & ~baseOrdinal;
        return SQTagUtil.baseAndProbDiffToSqValue(complementOrdinal, probDiff);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SQBase {
        SQ_A(Character.valueOf('A')),
        SQ_C(Character.valueOf('C')),
        SQ_G(Character.valueOf('G')),
        SQ_T(Character.valueOf('T'));

        private final Character base;

        private SQBase(Character base) {
            this.base = base;
        }

        public Character getBase() {
            return this.base;
        }
    }
}

