/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Chunk
implements Cloneable,
Serializable,
Comparable<Chunk> {
    private static final long serialVersionUID = 1L;
    private long mChunkStart;
    private long mChunkEnd;

    public Chunk(long start, long end) {
        this.mChunkStart = start;
        this.mChunkEnd = end;
    }

    public Chunk clone() {
        return new Chunk(this.mChunkStart, this.mChunkEnd);
    }

    protected long getChunkStart() {
        return this.mChunkStart;
    }

    protected void setChunkStart(long value) {
        this.mChunkStart = value;
    }

    protected long getChunkEnd() {
        return this.mChunkEnd;
    }

    protected void setChunkEnd(long value) {
        this.mChunkEnd = value;
    }

    @Override
    public int compareTo(Chunk chunk) {
        int result = Long.signum(this.mChunkStart - chunk.mChunkStart);
        if (result == 0) {
            result = Long.signum(this.mChunkEnd - chunk.mChunkEnd);
        }
        return result;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)o2;
        if (this.mChunkEnd != chunk.mChunkEnd) {
            return false;
        }
        return this.mChunkStart == chunk.mChunkStart;
    }

    public boolean overlaps(Chunk other) {
        long rightMostBlockAddress;
        int comparison = this.compareTo(other);
        if (comparison == 0) {
            return true;
        }
        Chunk leftMost = comparison == -1 ? this : other;
        Chunk rightMost = comparison == 1 ? this : other;
        long leftMostBlockAddress = BlockCompressedFilePointerUtil.getBlockAddress(leftMost.getChunkEnd());
        if (leftMostBlockAddress > (rightMostBlockAddress = BlockCompressedFilePointerUtil.getBlockAddress(rightMost.getChunkStart()))) {
            return true;
        }
        if (leftMostBlockAddress == rightMostBlockAddress) {
            int rightMostOffset;
            int leftMostOffset = BlockCompressedFilePointerUtil.getBlockOffset(leftMost.getChunkEnd());
            return leftMostOffset > (rightMostOffset = BlockCompressedFilePointerUtil.getBlockOffset(rightMost.getChunkStart()));
        }
        return false;
    }

    public boolean isAdjacentTo(Chunk other) {
        return BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockAddress(other.getChunkStart()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockOffset(other.getChunkStart()) || BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockAddress(other.getChunkEnd()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockOffset(other.getChunkEnd());
    }

    public int hashCode() {
        int result = (int)(this.mChunkStart ^ this.mChunkStart >>> 32);
        result = 31 * result + (int)(this.mChunkEnd ^ this.mChunkEnd >>> 32);
        return result;
    }

    public String toString() {
        return String.format("%d:%d-%d:%d", this.mChunkStart >> 16, this.mChunkStart & 0xFFFFL, this.mChunkEnd >> 16, this.mChunkEnd & 0xFFFFL);
    }
}

