/*
 * Decompiled with CFR 0.152.
 */
package demos;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class RubberBand
extends Applet {
    int w = 200;
    int h = 200;
    Vector lines = new Vector();
    int np = 0;
    int x1;
    int y1;
    int x2;
    int y2;
    int xl;
    int yl;
    Image offImg;
    Graphics offGra;
    Button btnClear;
    Button btnUndo;

    public void init() {
        this.setLayout(new FlowLayout());
        this.btnClear = new Button("Clear");
        this.btnUndo = new Button("Undo");
        this.add(this.btnClear);
        this.add(this.btnUndo);
        new Color(0);
        this.setBackground(Color.black);
        new Color(0);
        this.setForeground(Color.white);
    }

    public void Dragupdate(Graphics g2) {
        g2.setXORMode(this.getBackground());
        new Color(0);
        this.setForeground(Color.blue);
        if (this.xl != -1) {
            g2.drawLine(this.x1, this.y1, this.xl, this.yl);
            if (this.x2 != -1) {
                g2.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
        }
    }

    public void update(Graphics g2) {
        Dimension dim = this.getSize();
        if (this.offGra == null) {
            this.offImg = this.createImage(dim.width, dim.height);
            this.offGra = this.offImg.getGraphics();
        }
        new Color(0);
        this.offGra.setColor(Color.black);
        this.offGra.fillRect(0, 0, dim.width, dim.height);
        new Color(0);
        this.offGra.setColor(Color.white);
        this.offGra.setPaintMode();
        for (int i2 = 0; i2 < this.np; ++i2) {
            Rectangle p2 = (Rectangle)this.lines.elementAt(i2);
            if (p2.width == -1) continue;
            this.offGra.drawLine(p2.x, p2.y, p2.width, p2.height);
        }
        g2.drawImage(this.offImg, 0, 0, null);
    }

    public boolean handleEvent(Event e2) {
        switch (e2.id) {
            case 501: {
                this.x1 = e2.x;
                this.y1 = e2.y;
                this.x2 = -1;
                return true;
            }
            case 502: {
                this.lines.addElement(new Rectangle(this.x1, this.y1, e2.x, e2.y));
                ++this.np;
                this.xl = -1;
                this.x2 = -1;
                this.repaint();
                return true;
            }
            case 506: {
                this.xl = this.x2;
                this.yl = this.y2;
                this.x2 = e2.x;
                this.y2 = e2.y;
                this.Dragupdate(this.getGraphics());
                return true;
            }
        }
        return super.handleEvent(e2);
    }

    public boolean action(Event e2, Object o2) {
        if (e2.target == this.btnClear) {
            this.resetDrawing();
        }
        if (e2.target == this.btnUndo) {
            this.undo();
        }
        return true;
    }

    public void undo() {
        if (this.np > 0) {
            this.lines.removeElementAt(this.np - 1);
            --this.np;
            this.repaint();
        }
    }

    public void resetDrawing() {
        this.lines.removeAllElements();
        this.np = 0;
        this.repaint();
    }
}

